C-----------------------------------------------------------------------
C
C                        SYRTHES version 3.4
C                        -------------------
C
C     This file is part of the SYRTHES Kernel, element of the
C     thermal code SYRTHES.
C
C     Copyright (C) 1988-2008 EDF S.A., France
C
C     contact: syrthes-support@edf.fr
C
C
C     The SYRTHES Kernel is free software; you can redistribute it
C     and/or modify it under the terms of the GNU General Public License
C     as published by the Free Software Foundation; either version 2 of
C     the License, or (at your option) any later version.
C
C     The SYRTHES Kernel is distributed in the hope that it will be
C     useful, but WITHOUT ANY WARRANTY; without even the implied warranty
C     of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
C     GNU General Public License for more details.
C
C
C     You should have received a copy of the GNU General Public License
C     along with the Code_Saturne Kernel; if not, write to the
C     Free Software Foundation, Inc.,
C     51 Franklin St, Fifth Floor,
C     Boston, MA  02110-1301  USA
C
C-----------------------------------------------------------------------
C/MEMBR ADD NAME=ROTATS,SSI=0
C
                        SUBROUTINE ROTATS
C                       *****************
C
     * (X,Y,Z,XT,YT,ZT,TX,TY,TZ,ARX,ARY,ARZ,AROTX,AROTY,AROTZ)
C
C***********************************************************************
C* SYRTHES 3.4.3                                    COPYRIGHT EDF 2008 *
C***********************************************************************
C AUTEURS : C. PENIGUEL, I. RUPP                                       *
C***********************************************************************
C                                                                      *
C   FONCTION :                                                         *
C   --------   A PARTIR D'UN POINT X,Y,Z, CALCULER SES NOUVELLES       *
C              COORDONNEES APRES UNE ROTATION DEFINIE PAR              *
C                   TX,TY,TZ : translation du repere d'origine         *
C                   ARX,ARY,ARZ : rotation du repere d'origine         *
C                   AROTX,AROTY,AROTZ : rotation propre du solide      *
C                                                                      *
C                      |                                  ROT          *
C          Translation |       Rotation \       /       \      /       *
C     |        T       |          R      \    /          \    /        *
C     |                o-------           \o/             \o/          *
C     |              /                     |               |           *
C     o-------      /                      |               |           *
C   /                                                                  *
C /                                                  Rotation du solide*
C                                                    dans son repere   *
C                                           -1    -1                   *
C   D'ou la transformation : T . R . ROT . R  .  T                     *
C                                                                      *
C***********************************************************************
C               (*)   (*)                 ARGUMENTS                    !
C   .________.______.____._____________________________________________.
C   !  NOM   ! TYPE !MODE!                  ROLE                       !
C   !________!______!____!_____________________________________________!
C   ! X,Y,Z  !   R  ! D  ! COORDONNEES INITIALES DU POINT              !
C   !XT,YT,ZT!   R  ! R  ! COORDONNEES TRANSFORMEES DU POINT           !
C   !TX,TY,TZ!   R  ! D  ! VECTEUR TRANSLATION DU REPERE INITIALE      !
C   !ARX,ARY,!   R  ! D  ! ANGLES DES AXES X, Y ET Z DU NOUVEAU REPERE !
C   ! ARZ    !      !    !                                             !
C   !AROTX,  !      !    ! ANGLES PAR RAPPORT A X,Y,ET Z DU REPERE     !
C   ! AROTY, !   R  ! D  ! LOCAL DE LA ROTATION DU SOLIDE              !
C   !  AROTZ !      !    !                                             !
C   !________!______!____!_____________________________________________!
C   ! COMMONS                                                          !
C   !__________________________________________________________________!
C   !/NLOFES/!      ! D  !                                             !
C   !/XREFER/!      ! D  !                                             !
C   !__________________________________________________________________!
C
C (*) TYPE : E (ENTIER), R (REEL), A (ALPHANUMERIQUE), T (TABLEAU)
C     ET TYPES COMPOSES
C (*) MODE : D (DONNEE NON MODIFIEE), R (RESULTAT), M (DONNEE MODIFIEE)
C            A (TABLEAU AUXILIAIRE)
C-----------------------------------------------------------------------
C     SOUS PROGRAMME(S) APPELE(S) : --
C                                   
C-----------------------------------------------------------------------
C     SOUS PROGRAMME(S) APPELANT(S) : IPERIO,MOBROT
C
C***********************************************************************
C
      IMPLICIT NONE
C
C**********************************************************************
C     DONNEES EN COMMON 
C**********************************************************************
C
#include "nlofes.h"
#include "xrefer.h"
C
C**********************************************************************
C
C..Variables externes
      DOUBLE PRECISION X,Y,Z,XT,YT,ZT,TX,TY,TZ,ARX,ARY,ARZ
      DOUBLE PRECISION AROTX,AROTY,AROTZ
C
C..Variables internes
      DOUBLE PRECISION PI,S1,S2,S3
      DOUBLE PRECISION CRX,SRX,CRY,SRY,CRZ,SRZ
      DOUBLE PRECISION COX,SOX,COY,SOY,COZ,SOZ
      DOUBLE PRECISION TR(4,4),RM1(4,4)
C
C**********************************************************************
C
C     0- Initialisations
C     ==================
C
C
      PI = 3.141592654
C
      ARY   = - ARY
      AROTY = - AROTY
C
      CRX = COS(ARX)
      SRX = SIN(ARX)
      CRY = COS(ARY)
      SRY = SIN(ARY)
      CRZ = COS(ARZ)
      SRZ = SIN(ARZ)
C
      COX = COS(AROTX)
      SOX = SIN(AROTX)
      COY = COS(AROTY)
      SOY = SIN(AROTY)
      COZ = COS(AROTZ)
      SOZ = SIN(AROTZ)
C
C
C     1- RECALAGE DU REPERE LOCAL SUR LE REPERE GLOBAL
C     ================================================
C
      RM1(4,1) = 0
      RM1(2,2) = (CRZ*CRY**2*CRX-SRZ*SRY*SRX+CRZ*SRY**2*CRX)/(CRZ**2*CRY
     &**2*CRX**2+CRZ**2*CRY**2*SRX**2+SRZ**2*CRY**2*CRX**2+SRZ**2*CRY**2
     &*SRX**2+SRZ**2*CRX**2*SRY**2+CRZ**2*SRY**2*SRX**2+CRZ**2*CRX**2*SR
     &Y**2+SRZ**2*SRY**2*SRX**2)
      RM1(1,1) = CRZ*CRY/(CRZ**2*CRY**2+SRZ**2*CRY**2+SRZ**2*SRY**2+CRZ*
     &*2*SRY**2)
      RM1(4,2) = 0
      RM1(1,4) = 0
      RM1(2,3) = CRY*SRX/(CRY**2*SRX**2+CRY**2*CRX**2+SRY**2*SRX**2+CRX*
     &*2*SRY**2)
      RM1(1,2) = SRZ*CRY/(CRZ**2*CRY**2+SRZ**2*CRY**2+SRZ**2*SRY**2+CRZ*
     &*2*SRY**2)
      RM1(4,3) = 0
      RM1(2,4) = 0
      RM1(1,3) = SRY/(CRY**2+SRY**2)
      RM1(3,3) = CRY*CRX/(CRY**2*SRX**2+CRY**2*CRX**2+SRY**2*SRX**2+CRX*
     &*2*SRY**2)
      RM1(3,4) = 0
      RM1(3,1) = -(-SRZ*CRY**2*SRX+CRZ*SRY*CRX-SRZ*SRY**2*SRX)/(CRZ**2*C
     &RY**2*CRX**2+CRZ**2*CRY**2*SRX**2+SRZ**2*CRY**2*CRX**2+SRZ**2*CRY*
     &*2*SRX**2+SRZ**2*CRX**2*SRY**2+CRZ**2*SRY**2*SRX**2+CRZ**2*CRX**2*
     &SRY**2+SRZ**2*SRY**2*SRX**2)
      RM1(4,4) = 1
      RM1(3,2) = -(CRZ*CRY**2*SRX+SRZ*SRY*CRX+CRZ*SRY**2*SRX)/(CRZ**2*CR
     &Y**2*CRX**2+CRZ**2*CRY**2*SRX**2+SRZ**2*CRY**2*CRX**2+SRZ**2*CRY**
     &2*SRX**2+SRZ**2*CRX**2*SRY**2+CRZ**2*SRY**2*SRX**2+CRZ**2*CRX**2*S
     &RY**2+SRZ**2*SRY**2*SRX**2)
      RM1(2,1) = -(SRZ*CRY**2*CRX+CRZ*SRY*SRX+SRZ*SRY**2*CRX)/(CRZ**2*CR
     &Y**2*CRX**2+CRZ**2*CRY**2*SRX**2+SRZ**2*CRY**2*CRX**2+SRZ**2*CRY**
     &2*SRX**2+SRZ**2*CRX**2*SRY**2+CRZ**2*SRY**2*SRX**2+CRZ**2*CRX**2*S
     &RY**2+SRZ**2*SRY**2*SRX**2)
C
C
C     2- TRANSFORMATION GENERALE
C     ==========================
C
      TR(4,1) = RM1(4,1)
      TR(2,2) = RM1(1,2)*SRZ*CRY*COZ*COY+RM1(1,2)*SOZ*COY*CRZ*CRX-RM1(1,
     &2)*SOZ*COY*SRZ*SRY*SRX-RM1(1,2)*SOY*CRZ*SRX-RM1(1,2)*SOY*SRZ*SRY*C
     &RX-RM1(2,2)*SRZ*CRY*SOZ*COX-RM1(2,2)*SRZ*CRY*COZ*SOY*SOX+RM1(2,2)*
     &CRZ*CRX*COZ*COX-RM1(2,2)*CRZ*CRX*SOZ*SOY*SOX-RM1(2,2)*SRZ*SRY*SRX*
     &COZ*COX+RM1(2,2)*SRZ*SRY*SRX*SOZ*SOY*SOX-RM1(2,2)*COY*SOX*CRZ*SRX-
     &RM1(2,2)*COY*SOX*SRZ*SRY*CRX+RM1(3,2)*SRZ*CRY*SOZ*SOX-RM1(3,2)*SRZ
     &*CRY*COZ*SOY*COX-RM1(3,2)*CRZ*CRX*COZ*SOX-RM1(3,2)*CRZ*CRX*SOZ*SOY
     &*COX+RM1(3,2)*SRZ*SRY*SRX*COZ*SOX+RM1(3,2)*SRZ*SRY*SRX*SOZ*SOY*COX
     &-RM1(3,2)*COY*COX*CRZ*SRX-RM1(3,2)*COY*COX*SRZ*SRY*CRX+TY*RM1(4,2)
      TR(1,1) = RM1(1,1)*CRZ*CRY*COZ*COY-RM1(1,1)*SOZ*COY*SRZ*CRX-RM1(1,
     &1)*SOZ*COY*CRZ*SRY*SRX+RM1(1,1)*SOY*SRZ*SRX-RM1(1,1)*SOY*CRZ*SRY*C
     &RX-RM1(2,1)*CRZ*CRY*SOZ*COX-RM1(2,1)*CRZ*CRY*COZ*SOY*SOX-RM1(2,1)*
     &SRZ*CRX*COZ*COX+RM1(2,1)*SRZ*CRX*SOZ*SOY*SOX-RM1(2,1)*CRZ*SRY*SRX*
     &COZ*COX+RM1(2,1)*CRZ*SRY*SRX*SOZ*SOY*SOX+RM1(2,1)*COY*SOX*SRZ*SRX-
     &RM1(2,1)*COY*SOX*CRZ*SRY*CRX+RM1(3,1)*CRZ*CRY*SOZ*SOX-RM1(3,1)*CRZ
     &*CRY*COZ*SOY*COX+RM1(3,1)*SRZ*CRX*COZ*SOX+RM1(3,1)*SRZ*CRX*SOZ*SOY
     &*COX+RM1(3,1)*CRZ*SRY*SRX*COZ*SOX+RM1(3,1)*CRZ*SRY*SRX*SOZ*SOY*COX
     &+RM1(3,1)*COY*COX*SRZ*SRX-RM1(3,1)*COY*COX*CRZ*SRY*CRX+TX*RM1(4,1)
      TR(4,2) = RM1(4,2)
      s3 = -TY*RM1(1,2)*SOY*SRZ*SRX+TX*RM1(3,1)*COY*COX*CRZ*SRY*CRX-TX*R
     &M1(3,1)*CRZ*SRY*SRX*COZ*SOX-TX*RM1(3,1)*SRZ*CRX*SOZ*SOY*COX-TX*RM1
     &(3,1)*COY*COX*SRZ*SRX+TX*RM1(3,1)*CRZ*CRY*COZ*SOY*COX+TZ*RM1(2,3)*
     &SRZ*CRX*COZ*COX+TZ*RM1(2,3)*CRZ*CRY*SOZ*COX+TZ*RM1(1,3)*SOY*CRZ*SR
     &Y*CRX-TZ*RM1(1,3)*SOY*SRZ*SRX+TZ*RM1(1,3)*SOZ*COY*SRZ*CRX
      s2 = s3-TZ*RM1(1,3)*CRZ*CRY*COZ*COY+TX*RM1(2,1)*COY*SOX*CRZ*SRY*CR
     &X+TX*RM1(2,1)*CRZ*SRY*SRX*COZ*COX-TX*RM1(2,1)*COY*SOX*SRZ*SRX-TX*R
     &M1(2,1)*SRZ*CRX*SOZ*SOY*SOX-TZ*TX*RM1(4,3)+TX*RM1(2,1)*CRZ*CRY*COZ
     &*SOY*SOX+TX*RM1(1,1)*SOZ*COY*CRZ*SRY*SRX-TX*RM1(1,1)*SOY*SRZ*SRX+T
     &Y*RM1(3,2)*COY*COX*CRZ*SRY*CRX-TY*TX*RM1(4,2)
      s3 = s2+TY*RM1(1,2)*SOY*CRZ*SRY*CRX+TY*RM1(1,2)*SOZ*COY*SRZ*CRX-TY
     &*RM1(1,2)*CRZ*CRY*COZ*COY-TZ*RM1(3,3)*COY*COX*SRZ*SRX-TZ*RM1(3,3)*
     &CRZ*SRY*SRX*SOZ*SOY*COX-TZ*RM1(3,3)*SRZ*CRX*COZ*SOX-TZ*RM1(3,3)*CR
     &Z*CRY*SOZ*SOX-TZ*RM1(2,3)*COY*SOX*SRZ*SRX-RM1(2,4)*CRZ*SRY*SRX*COZ
     &*COX-TZ*RM1(2,3)*CRZ*SRY*SRX*SOZ*SOY*SOX
      s1 = s3-TY*RM1(3,2)*CRZ*SRY*SRX*COZ*SOX-TX*RM1(3,1)*CRZ*SRY*SRX*SO
     &Z*SOY*COX-TX*RM1(3,1)*SRZ*CRX*COZ*SOX-TX*RM1(3,1)*CRZ*CRY*SOZ*SOX-
     &TX*RM1(2,1)*CRZ*SRY*SRX*SOZ*SOY*SOX+TX*RM1(2,1)*SRZ*CRX*COZ*COX+TX
     &*RM1(2,1)*CRZ*CRY*SOZ*COX+TX*RM1(1,1)*SOY*CRZ*SRY*CRX+TZ*RM1(1,3)*
     &SOZ*COY*CRZ*SRY*SRX+TX*RM1(1,1)*SOZ*COY*SRZ*CRX-TY*RM1(3,2)*SRZ*CR
     &X*SOZ*SOY*COX-TX*RM1(1,1)*CRZ*CRY*COZ*COY
      s3 = -TY*RM1(3,2)*COY*COX*SRZ*SRX-TY*RM1(3,2)*CRZ*SRY*SRX*SOZ*SOY*
     &COX-TY*RM1(3,2)*SRZ*CRX*COZ*SOX+RM1(3,4)*SRZ*CRX*COZ*SOX-TY*RM1(3,
     &2)*CRZ*CRY*SOZ*SOX-TY*RM1(2,2)*COY*SOX*SRZ*SRX-TY*RM1(2,2)*CRZ*SRY
     &*SRX*SOZ*SOY*SOX+TY*RM1(2,2)*SRZ*CRX*COZ*COX-TX**2*RM1(4,1)+TY*RM1
     &(2,2)*CRZ*CRY*SOZ*COX+TZ*RM1(2,3)*CRZ*CRY*COZ*SOY*SOX
      s2 = s3-RM1(2,4)*CRZ*CRY*COZ*SOY*SOX-TZ*RM1(2,3)*SRZ*CRX*SOZ*SOY*S
     &OX+RM1(2,4)*SRZ*CRX*SOZ*SOY*SOX+TZ*RM1(2,3)*COY*SOX*CRZ*SRY*CRX+TZ
     &*RM1(2,3)*CRZ*SRY*SRX*COZ*COX+TZ*RM1(3,3)*CRZ*CRY*COZ*SOY*COX+s1-T
     &Y*RM1(2,2)*SRZ*CRX*SOZ*SOY*SOX+TY*RM1(2,2)*CRZ*CRY*COZ*SOY*SOX+TY*
     &RM1(1,2)*SOZ*COY*CRZ*SRY*SRX+TZ*RM1(3,3)*COY*COX*CRZ*SRY*CRX
      s3 = s2-TZ*RM1(3,3)*CRZ*SRY*SRX*COZ*SOX-TZ*RM1(3,3)*SRZ*CRX*SOZ*SO
     &Y*COX+TY*RM1(2,2)*COY*SOX*CRZ*SRY*CRX+TY*RM1(2,2)*CRZ*SRY*SRX*COZ*
     &COX+TY*RM1(3,2)*CRZ*CRY*COZ*SOY*COX+TX*RM1(4,4)+RM1(1,4)*CRZ*CRY*C
     &OZ*COY-RM1(1,4)*SOZ*COY*SRZ*CRX-RM1(1,4)*SOZ*COY*CRZ*SRY*SRX+RM1(1
     &,4)*SOY*SRZ*SRX-RM1(1,4)*SOY*CRZ*SRY*CRX
      TR(1,4) = s3-RM1(2,4)*CRZ*CRY*SOZ*COX-RM1(2,4)*SRZ*CRX*COZ*COX+RM1
     &(2,4)*CRZ*SRY*SRX*SOZ*SOY*SOX+RM1(2,4)*COY*SOX*SRZ*SRX-RM1(2,4)*CO
     &Y*SOX*CRZ*SRY*CRX+RM1(3,4)*CRZ*CRY*SOZ*SOX-RM1(3,4)*CRZ*CRY*COZ*SO
     &Y*COX+RM1(3,4)*SRZ*CRX*SOZ*SOY*COX+RM1(3,4)*CRZ*SRY*SRX*COZ*SOX+RM
     &1(3,4)*CRZ*SRY*SRX*SOZ*SOY*COX+RM1(3,4)*COY*COX*SRZ*SRX-RM1(3,4)*C
     &OY*COX*CRZ*SRY*CRX
      TR(2,3) = RM1(1,3)*SRZ*CRY*COZ*COY+RM1(1,3)*SOZ*COY*CRZ*CRX-RM1(1,
     &3)*SOZ*COY*SRZ*SRY*SRX-RM1(1,3)*SOY*CRZ*SRX-RM1(1,3)*SOY*SRZ*SRY*C
     &RX-RM1(2,3)*SRZ*CRY*SOZ*COX-RM1(2,3)*SRZ*CRY*COZ*SOY*SOX+RM1(2,3)*
     &CRZ*CRX*COZ*COX-RM1(2,3)*CRZ*CRX*SOZ*SOY*SOX-RM1(2,3)*SRZ*SRY*SRX*
     &COZ*COX+RM1(2,3)*SRZ*SRY*SRX*SOZ*SOY*SOX-RM1(2,3)*COY*SOX*CRZ*SRX-
     &RM1(2,3)*COY*SOX*SRZ*SRY*CRX+RM1(3,3)*SRZ*CRY*SOZ*SOX-RM1(3,3)*SRZ
     &*CRY*COZ*SOY*COX-RM1(3,3)*CRZ*CRX*COZ*SOX-RM1(3,3)*CRZ*CRX*SOZ*SOY
     &*COX+RM1(3,3)*SRZ*SRY*SRX*COZ*SOX+RM1(3,3)*SRZ*SRY*SRX*SOZ*SOY*COX
     &-RM1(3,3)*COY*COX*CRZ*SRX-RM1(3,3)*COY*COX*SRZ*SRY*CRX+TY*RM1(4,3)
      TR(1,2) = RM1(1,2)*CRZ*CRY*COZ*COY-RM1(1,2)*SOZ*COY*SRZ*CRX-RM1(1,
     &2)*SOZ*COY*CRZ*SRY*SRX+RM1(1,2)*SOY*SRZ*SRX-RM1(1,2)*SOY*CRZ*SRY*C
     &RX-RM1(2,2)*CRZ*CRY*SOZ*COX-RM1(2,2)*CRZ*CRY*COZ*SOY*SOX-RM1(2,2)*
     &SRZ*CRX*COZ*COX+RM1(2,2)*SRZ*CRX*SOZ*SOY*SOX-RM1(2,2)*CRZ*SRY*SRX*
     &COZ*COX+RM1(2,2)*CRZ*SRY*SRX*SOZ*SOY*SOX+RM1(2,2)*COY*SOX*SRZ*SRX-
     &RM1(2,2)*COY*SOX*CRZ*SRY*CRX+RM1(3,2)*CRZ*CRY*SOZ*SOX-RM1(3,2)*CRZ
     &*CRY*COZ*SOY*COX+RM1(3,2)*SRZ*CRX*COZ*SOX+RM1(3,2)*SRZ*CRX*SOZ*SOY
     &*COX+RM1(3,2)*CRZ*SRY*SRX*COZ*SOX+RM1(3,2)*CRZ*SRY*SRX*SOZ*SOY*COX
     &+RM1(3,2)*COY*COX*SRZ*SRX-RM1(3,2)*COY*COX*CRZ*SRY*CRX+TX*RM1(4,2)
      TR(4,3) = RM1(4,3)
      s3 = TZ*RM1(2,3)*SRZ*SRY*SRX*COZ*COX+TZ*RM1(2,3)*CRZ*CRX*SOZ*SOY*S
     &OX+TZ*RM1(2,3)*COY*SOX*CRZ*SRX+TZ*RM1(1,3)*SOZ*COY*SRZ*SRY*SRX+TX*
     &RM1(2,1)*SRZ*SRY*SRX*COZ*COX+TX*RM1(2,1)*COY*SOX*CRZ*SRX+TX*RM1(2,
     &1)*CRZ*CRX*SOZ*SOY*SOX+TX*RM1(2,1)*SRZ*CRY*COZ*SOY*SOX+TX*RM1(1,1)
     &*SOZ*COY*SRZ*SRY*SRX+TY*RM1(3,2)*COY*COX*SRZ*SRY*CRX-TY*RM1(3,2)*S
     &RZ*SRY*SRX*COZ*SOX
      s2 = s3+TY*RM1(3,2)*CRZ*CRX*SOZ*SOY*COX+TY*RM1(3,2)*SRZ*CRY*COZ*SO
     &Y*COX+TY*RM1(2,2)*COY*SOX*SRZ*SRY*CRX-RM1(3,4)*COY*COX*CRZ*SRX+TY*
     &RM1(2,2)*SRZ*SRY*SRX*COZ*COX-TY*RM1(2,2)*SRZ*SRY*SRX*SOZ*SOY*SOX+T
     &Y*RM1(1,2)*SOZ*COY*SRZ*SRY*SRX-TX*TY*RM1(4,1)+TZ*RM1(3,3)*COY*COX*
     &SRZ*SRY*CRX-TZ*RM1(3,3)*SRZ*SRY*SRX*COZ*SOX+TZ*RM1(3,3)*CRZ*CRX*SO
     &Z*SOY*COX
      s3 = s2+TZ*RM1(3,3)*COY*COX*CRZ*SRX+TZ*RM1(3,3)*SRZ*CRY*COZ*SOY*CO
     &X+TZ*RM1(3,3)*CRZ*CRX*COZ*SOX+TZ*RM1(2,3)*COY*SOX*SRZ*SRY*CRX+TZ*R
     &M1(2,3)*SRZ*CRY*COZ*SOY*SOX-TZ*RM1(2,3)*CRZ*CRX*COZ*COX+TY*RM1(2,2
     &)*SRZ*CRY*COZ*SOY*SOX+TY*RM1(2,2)*CRZ*CRX*SOZ*SOY*SOX-TZ*TY*RM1(4,
     &3)-RM1(1,4)*SOY*CRZ*SRX
      s1 = s3+TX*RM1(3,1)*COY*COX*SRZ*SRY*CRX-TX*RM1(3,1)*SRZ*SRY*SRX*CO
     &Z*SOX-RM1(3,4)*COY*COX*SRZ*SRY*CRX+TX*RM1(3,1)*CRZ*CRX*SOZ*SOY*COX
     &+TX*RM1(2,1)*COY*SOX*SRZ*SRY*CRX+TX*RM1(3,1)*SRZ*CRY*COZ*SOY*COX-T
     &Z*RM1(2,3)*SRZ*SRY*SRX*SOZ*SOY*SOX+TX*RM1(1,1)*SOY*CRZ*SRX+TY*RM1(
     &1,2)*SOY*CRZ*SRX+TZ*RM1(2,3)*SRZ*CRY*SOZ*COX+TZ*RM1(1,3)*SOY*SRZ*S
     &RY*CRX-TZ*RM1(1,3)*SOZ*COY*CRZ*CRX
      s3 = -TY**2*RM1(4,2)+TZ*RM1(1,3)*SOY*CRZ*SRX-TZ*RM1(1,3)*SRZ*CRY*C
     &OZ*COY+TY*RM1(2,2)*COY*SOX*CRZ*SRX-TY*RM1(2,2)*CRZ*CRX*COZ*COX+TY*
     &RM1(2,2)*SRZ*CRY*SOZ*COX+TY*RM1(1,2)*SOY*SRZ*SRY*CRX-TY*RM1(1,2)*S
     &OZ*COY*CRZ*CRX-TY*RM1(1,2)*SRZ*CRY*COZ*COY-TZ*RM1(3,3)*SRZ*SRY*SRX
     &*SOZ*SOY*COX-TZ*RM1(3,3)*SRZ*CRY*SOZ*SOX
      s2 = s3-RM1(1,4)*SOY*SRZ*SRY*CRX-TX*RM1(2,1)*SRZ*SRY*SRX*SOZ*SOY*S
     &OX-TX*RM1(2,1)*CRZ*CRX*COZ*COX+TX*RM1(2,1)*SRZ*CRY*SOZ*COX+TX*RM1(
     &1,1)*SOY*SRZ*SRY*CRX-TX*RM1(1,1)*SOZ*COY*CRZ*CRX-TX*RM1(1,1)*SRZ*C
     &RY*COZ*COY+TY*RM1(3,2)*COY*COX*CRZ*SRX-TY*RM1(3,2)*SRZ*SRY*SRX*SOZ
     &*SOY*COX+TY*RM1(3,2)*CRZ*CRX*COZ*SOX-TY*RM1(3,2)*SRZ*CRY*SOZ*SOX
      s3 = s2+TX*RM1(3,1)*COY*COX*CRZ*SRX-TX*RM1(3,1)*SRZ*SRY*SRX*SOZ*SO
     &Y*COX+TX*RM1(3,1)*CRZ*CRX*COZ*SOX-TX*RM1(3,1)*SRZ*CRY*SOZ*SOX+s1+T
     &Y*RM1(4,4)+RM1(1,4)*SRZ*CRY*COZ*COY+RM1(1,4)*SOZ*COY*CRZ*CRX-RM1(1
     &,4)*SOZ*COY*SRZ*SRY*SRX-RM1(2,4)*SRZ*CRY*SOZ*COX-RM1(2,4)*SRZ*CRY*
     &COZ*SOY*SOX
      TR(2,4) = s3+RM1(2,4)*CRZ*CRX*COZ*COX-RM1(2,4)*CRZ*CRX*SOZ*SOY*SOX
     &-RM1(2,4)*SRZ*SRY*SRX*COZ*COX+RM1(2,4)*SRZ*SRY*SRX*SOZ*SOY*SOX-RM1
     &(2,4)*COY*SOX*CRZ*SRX-RM1(2,4)*COY*SOX*SRZ*SRY*CRX+RM1(3,4)*SRZ*CR
     &Y*SOZ*SOX-RM1(3,4)*SRZ*CRY*COZ*SOY*COX-RM1(3,4)*CRZ*CRX*COZ*SOX-RM
     &1(3,4)*CRZ*CRX*SOZ*SOY*COX+RM1(3,4)*SRZ*SRY*SRX*COZ*SOX+RM1(3,4)*S
     &RZ*SRY*SRX*SOZ*SOY*COX
      TR(1,3) = RM1(1,3)*CRZ*CRY*COZ*COY-RM1(1,3)*SOZ*COY*SRZ*CRX-RM1(1,
     &3)*SOZ*COY*CRZ*SRY*SRX+RM1(1,3)*SOY*SRZ*SRX-RM1(1,3)*SOY*CRZ*SRY*C
     &RX-RM1(2,3)*CRZ*CRY*SOZ*COX-RM1(2,3)*CRZ*CRY*COZ*SOY*SOX-RM1(2,3)*
     &SRZ*CRX*COZ*COX+RM1(2,3)*SRZ*CRX*SOZ*SOY*SOX-RM1(2,3)*CRZ*SRY*SRX*
     &COZ*COX+RM1(2,3)*CRZ*SRY*SRX*SOZ*SOY*SOX+RM1(2,3)*COY*SOX*SRZ*SRX-
     &RM1(2,3)*COY*SOX*CRZ*SRY*CRX+RM1(3,3)*CRZ*CRY*SOZ*SOX-RM1(3,3)*CRZ
     &*CRY*COZ*SOY*COX+RM1(3,3)*SRZ*CRX*COZ*SOX+RM1(3,3)*SRZ*CRX*SOZ*SOY
     &*COX+RM1(3,3)*CRZ*SRY*SRX*COZ*SOX+RM1(3,3)*CRZ*SRY*SRX*SOZ*SOY*COX
     &+RM1(3,3)*COY*COX*SRZ*SRX-RM1(3,3)*COY*COX*CRZ*SRY*CRX+TX*RM1(4,3)
      TR(3,3) = RM1(1,3)*SRY*COZ*COY+RM1(1,3)*CRY*SRX*SOZ*COY+RM1(1,3)*C
     &RY*CRX*SOY-RM1(2,3)*SRY*SOZ*COX-RM1(2,3)*SRY*COZ*SOY*SOX+RM1(2,3)*
     &CRY*SRX*COZ*COX-RM1(2,3)*CRY*SRX*SOZ*SOY*SOX+RM1(2,3)*CRY*CRX*COY*
     &SOX+RM1(3,3)*SRY*SOZ*SOX-RM1(3,3)*SRY*COZ*SOY*COX-RM1(3,3)*CRY*SRX
     &*COZ*SOX-RM1(3,3)*CRY*SRX*SOZ*SOY*COX+RM1(3,3)*CRY*CRX*COY*COX+TZ*
     &RM1(4,3)
      s2 = -RM1(2,4)*SRY*COZ*SOY*SOX+RM1(1,4)*SRY*COZ*COY+TY*RM1(2,2)*CR
     &Y*SRX*SOZ*SOY*SOX+TZ*RM1(3,3)*SRY*COZ*SOY*COX-TZ*RM1(2,3)*CRY*CRX*
     &COY*SOX+TZ*RM1(2,3)*CRY*SRX*SOZ*SOY*SOX+TZ*RM1(2,3)*SRY*COZ*SOY*SO
     &X-TZ*RM1(2,3)*CRY*SRX*COZ*COX+TY*RM1(3,2)*CRY*SRX*SOZ*SOY*COX+TX*R
     &M1(3,1)*CRY*SRX*SOZ*SOY*COX+TX*RM1(2,1)*CRY*SRX*SOZ*SOY*SOX+TZ*RM1
     &(3,3)*CRY*SRX*COZ*SOX-TZ*RM1(3,3)*CRY*CRX*COY*COX+TZ*RM1(3,3)*CRY*
     &SRX*SOZ*SOY*COX
      s1 = s2-TX*RM1(1,1)*CRY*CRX*SOY-TX*RM1(1,1)*SRY*COZ*COY-TX*TZ*RM1(
     &4,1)+RM1(1,4)*CRY*SRX*SOZ*COY-TX*RM1(1,1)*CRY*SRX*SOZ*COY-TX*RM1(3
     &,1)*SRY*SOZ*SOX+TX*RM1(2,1)*SRY*SOZ*COX-TY*TZ*RM1(4,2)-TZ**2*RM1(4
     &,3)-TX*RM1(2,1)*CRY*CRX*COY*SOX+TY*RM1(2,2)*SRY*SOZ*COX-TY*RM1(1,2
     &)*CRY*CRX*SOY-TY*RM1(1,2)*SRY*COZ*COY-TX*RM1(2,1)*CRY*SRX*COZ*COX
      s2 = s1+TX*RM1(2,1)*SRY*COZ*SOY*SOX-TX*RM1(3,1)*CRY*CRX*COY*COX+TX
     &*RM1(3,1)*CRY*SRX*COZ*SOX-TZ*RM1(3,3)*SRY*SOZ*SOX+TZ*RM1(2,3)*SRY*
     &SOZ*COX-TZ*RM1(1,3)*CRY*CRX*SOY-TZ*RM1(1,3)*SRY*COZ*COY+TX*RM1(3,1
     &)*SRY*COZ*SOY*COX-TY*RM1(3,2)*SRY*SOZ*SOX-TZ*RM1(1,3)*CRY*SRX*SOZ*
     &COY-TY*RM1(3,2)*CRY*CRX*COY*COX+TY*RM1(3,2)*CRY*SRX*COZ*SOX+TY*RM1
     &(3,2)*SRY*COZ*SOY*COX
      TR(3,4) = s2-TY*RM1(2,2)*CRY*CRX*COY*SOX-TY*RM1(2,2)*CRY*SRX*COZ*C
     &OX+TY*RM1(2,2)*SRY*COZ*SOY*SOX-TY*RM1(1,2)*CRY*SRX*SOZ*COY+TZ*RM1(
     &4,4)+RM1(1,4)*CRY*CRX*SOY-RM1(2,4)*SRY*SOZ*COX+RM1(2,4)*CRY*SRX*CO
     &Z*COX-RM1(2,4)*CRY*SRX*SOZ*SOY*SOX+RM1(2,4)*CRY*CRX*COY*SOX+RM1(3,
     &4)*SRY*SOZ*SOX-RM1(3,4)*SRY*COZ*SOY*COX-RM1(3,4)*CRY*SRX*COZ*SOX-R
     &M1(3,4)*CRY*SRX*SOZ*SOY*COX+RM1(3,4)*CRY*CRX*COY*COX
      TR(3,1) = RM1(1,1)*SRY*COZ*COY+RM1(1,1)*CRY*SRX*SOZ*COY+RM1(1,1)*C
     &RY*CRX*SOY-RM1(2,1)*SRY*SOZ*COX-RM1(2,1)*SRY*COZ*SOY*SOX+RM1(2,1)*
     &CRY*SRX*COZ*COX-RM1(2,1)*CRY*SRX*SOZ*SOY*SOX+RM1(2,1)*CRY*CRX*COY*
     &SOX+RM1(3,1)*SRY*SOZ*SOX-RM1(3,1)*SRY*COZ*SOY*COX-RM1(3,1)*CRY*SRX
     &*COZ*SOX-RM1(3,1)*CRY*SRX*SOZ*SOY*COX+RM1(3,1)*CRY*CRX*COY*COX+TZ*
     &RM1(4,1)
      TR(4,4) = -TX*RM1(4,1)-TY*RM1(4,2)-TZ*RM1(4,3)+RM1(4,4)
      TR(3,2) = RM1(1,2)*SRY*COZ*COY+RM1(1,2)*CRY*SRX*SOZ*COY+RM1(1,2)*C
     &RY*CRX*SOY-RM1(2,2)*SRY*SOZ*COX-RM1(2,2)*SRY*COZ*SOY*SOX+RM1(2,2)*
     &CRY*SRX*COZ*COX-RM1(2,2)*CRY*SRX*SOZ*SOY*SOX+RM1(2,2)*CRY*CRX*COY*
     &SOX+RM1(3,2)*SRY*SOZ*SOX-RM1(3,2)*SRY*COZ*SOY*COX-RM1(3,2)*CRY*SRX
     &*COZ*SOX-RM1(3,2)*CRY*SRX*SOZ*SOY*COX+RM1(3,2)*CRY*CRX*COY*COX+TZ*
     &RM1(4,2)
      TR(2,1) = RM1(1,1)*SRZ*CRY*COZ*COY+RM1(1,1)*SOZ*COY*CRZ*CRX-RM1(1,
     &1)*SOZ*COY*SRZ*SRY*SRX-RM1(1,1)*SOY*CRZ*SRX-RM1(1,1)*SOY*SRZ*SRY*C
     &RX-RM1(2,1)*SRZ*CRY*SOZ*COX-RM1(2,1)*SRZ*CRY*COZ*SOY*SOX+RM1(2,1)*
     &CRZ*CRX*COZ*COX-RM1(2,1)*CRZ*CRX*SOZ*SOY*SOX-RM1(2,1)*SRZ*SRY*SRX*
     &COZ*COX+RM1(2,1)*SRZ*SRY*SRX*SOZ*SOY*SOX-RM1(2,1)*COY*SOX*CRZ*SRX-
     &RM1(2,1)*COY*SOX*SRZ*SRY*CRX+RM1(3,1)*SRZ*CRY*SOZ*SOX-RM1(3,1)*SRZ
     &*CRY*COZ*SOY*COX-RM1(3,1)*CRZ*CRX*COZ*SOX-RM1(3,1)*CRZ*CRX*SOZ*SOY
     &*COX+RM1(3,1)*SRZ*SRY*SRX*COZ*SOX+RM1(3,1)*SRZ*SRY*SRX*SOZ*SOY*COX
     &-RM1(3,1)*COY*COX*CRZ*SRX-RM1(3,1)*COY*COX*SRZ*SRY*CRX+TY*RM1(4,1)
C
C
C     3- CALCUL DES NOUVELLES COORDONNEES
C     ===================================
C
      XT = TR(1,1)*X+TR(1,2)*Y+TR(1,3)*Z+TR(1,4)
      YT = TR(2,1)*X+TR(2,2)*Y+TR(2,3)*Z+TR(2,4)
      ZT = TR(3,1)*X+TR(3,2)*Y+TR(3,3)*Z+TR(3,4)
C
C
C
C--------
C FORMATS
C--------
C----
C FIN
C----
C
      RETURN
      END
