C-----------------------------------------------------------------------
C
C                        SYRTHES version 3.4
C                        -------------------
C
C     This file is part of the SYRTHES Kernel, element of the
C     thermal code SYRTHES.
C
C     Copyright (C) 1988-2008 EDF S.A., France
C
C     contact: syrthes-support@edf.fr
C
C
C     The SYRTHES Kernel is free software; you can redistribute it
C     and/or modify it under the terms of the GNU General Public License
C     as published by the Free Software Foundation; either version 2 of
C     the License, or (at your option) any later version.
C
C     The SYRTHES Kernel is distributed in the hope that it will be
C     useful, but WITHOUT ANY WARRANTY; without even the implied warranty
C     of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
C     GNU General Public License for more details.
C
C
C     You should have received a copy of the GNU General Public License
C     along with the Code_Saturne Kernel; if not, write to the
C     Free Software Foundation, Inc.,
C     51 Franklin St, Fifth Floor,
C     Boston, MA  02110-1301  USA
C
C-----------------------------------------------------------------------
C/MEMBR ADD NAME=DIFFCO,SSI=0
C
                     SUBROUTINE DIFFCO
C                    *****************
C
C     ---------------------------------------------------
     *( TMPS,TMPSA,TMPSC1,TMPSC2,TMPSC3,B,DMAT, 
     *  XMAT,PHYSOL,COORDS,NODES,NFLUVS,VFLUVS,  
     *  NDIRS,VDIRS,NFCOUS,VFCOUS,NFFLUS,VFFLUS,
     *  NFECHS,VFECHS,NFRAYS,VFRAYS,NPRIOS,NODEPR,
     *  VOLUME,DIAG,
     *  NPOINS,NELEMS,NDIELE,NCOEMA,NDMATS,NDIM,
     *  NBDIRS,NBFFLU,NBFLVS,NBFECH,NBPHYS,
     *  NBFRAY,NBPRIO,NBCOPR,NELEPR,TRAVF,
     *  TRAV1,TRAV2,TRAV3,TRAV4,WCT )
C     ----------------------------------------------------
C***********************************************************************
C* SYRTHES 3.4.3                                    COPYRIGHT EDF 2008 *
C***********************************************************************
C AUTEURS : C. PENIGUEL, I. RUPP                                       *
C***********************************************************************
C                                                                      *
C      FONCTION :                                                      *
C      ---------     TRAITEMENT DE LA DIFFUSION SOLIDE                 *
C                    CAS  COQUE                                        *
C                    Ce sous-programme traite les conditions exterieurs*
C                    a partir des faces,ce qui permet une meilleure    *
C                    prise en compte des discontinuites, qui dans le   *
C                    cas coque ont une justification physique moins    *
C                    grande.                                           *
C                                                                      *
C-----------------------------------------------------------------------
C		    (*)    (*)			ARGUMENTS
C   .___________.______._______________________________________________.
C   !    NOM    ! TYPE !MODE!                    ROLE                  !
C   !___________!______!____!__________________________________________!
C   !   TMPSA   !  TR  ! R  ! TEMPERATURE EN CHAQUE POINT interieur    !
C   !   TMPS    !  TR  ! D  ! TEMPERATURE EN CHAQUE POINT exterieur    !
C   !   TMPSC1  !  TR  ! D  ! 1er  COEF DE TEMPERATURE                 !
C   !   TMPSC2  !  TR  ! D  ! 2eme COEF DE TEMPERATURE                 !
C   !   TMPSC3  !  TR  ! D  ! 3eme COEF DE TEMPERATURE                 !
C   !   DMAT    !  TR  ! M  ! DIAGONALE DE LA MATRICE M                !
C   !   XMAT    !  TR  ! M  ! TERMES EXTRA DIAGONAUX DE LA MATRICE M   !
C   !   PHYSOL  !  TR  ! D  ! CARACTERISTIQUE DU SOLIDE                !
C   !           !      !    !   physol(n,1) = rho masse vol            !
C   !           !      !    !   physol(n,2) = Cp chaleur specifique    !
C   !           !      !    !   physol(n,3) = k conductivite surfacique!
C   !           !      !    !   physol(n,4) = K conductivite epaisseur !
C   !           !      !    !   physol(n,5) = H (R courbure principal) !
C   !           !      !    !   physol(n,6) = e (epaisseur locale)     !
C   !   COORDS  !  TR  ! D  ! COORDONNEES DU MAILLAGE                  !
C   !   NODES   !  TE  ! D  ! CORRESPONDANCE NOEUDS LOCAUX GLOBAUX     !
C   !   NFFLUS  !  TE  ! D  ! No de facette flux ---> face glob        !
C   !   VFFLUS  !  TR  ! D  ! Valeur des flux a chaque point de la face!
C   !   NBFFLU  !  E   ! D  ! Nombre de facette de type flux           ! 
C   !   NFECHS  !  TE  ! D  ! No de facette echange ---> face glob     !
C   !   VFECHS  !  TR  ! D  ! Valeur des echan aux points de la face   !
C   !   NBFECH  !  E   ! D  ! Nombre de facette de type echange        ! 
C   !   NFRAYS  !  TE  ! D  ! No de facette rayonnement ---> face glob !
C   !   VFRAYS  !  TR  ! D  ! Valeur du rayo aux points de la face     !
C   !   NBFRAY  !  E   ! D  ! Nombre de facette de type rayonnement    ! 
C   !   NFCOUS  !  TE  ! D  ! No de facette couplee ---> face glob     !
C   !   VFCOUS  !  TR  ! D  ! Valeur du couplage aux points de la face !
C   !   NELESS  !  E   ! D  ! Nombre de facette de type couplee        ! 
C   !   VOLUME  !  TR  ! D  ! SURFACE DU TRIANGLE EN COQUE             !
C   !   DIAG    !  TR  ! M  ! DIAGONALE DE PRECONDITIONNEMENT          !
C   !   TRAV1   !  TR  ! M  ! TABLEAU DE TRAVAIL (Taille: NPOINS)      !
C   !   TRAV2   !  TR  ! M  ! TABLEAU DE TRAVAIL (Taille: NPOINS)      ! 
C   !   TRAV3   !  TR  ! M  ! TABLEAU DE TRAVAIL (Taille: NPOINS)      ! 
C   !   TRAV4   !  TR  ! M  ! TABLEAU DE TRAVAIL (Taille: NPOINS)      !
C   !   WCT     !  TR  ! M  ! TABLEAUX DE TRAVAIL NELEMS * NDMATS      !
C   !___________!______!____!__________________________________________!
C (*) TYPE : E (ENTIER), R (REEL), A (ALPHANUMERIQUE), T (TABLEAU)
C     ET TYPES COMPOSES
C (*) MODE : D (DONNEE NON MODIFIEE), R (RESULTAT), M (DONNEE MODIFIEE)
C            A (TABLEAU AUXILIAIRE)
C-----------------------------------------------------------------------
C    SOUS PROGRAMME(S) APPELE(S)    : ????
C                                     ????
C-----------------------------------------------------------------------
C    SOUS PROGRAMME(S) APPELANT(S)  : ????
C
C***********************************************************************
C
	IMPLICIT NONE
C
C***********************************************************************
C	DONNEES EN COMMON
C***********************************************************************
C
#include "optct.h"
#include "nlofes.h"
C
C***********************************************************************
C
C..Variables externes
      INTEGER NPOINS,NELEMS,NDIELE,NCOEMA,NDMATS,NDIM
      INTEGER NBDIRS,NBFLVS,NBPHYS
      INTEGER NBPRIO,NBCOPR,NELEPR
      INTEGER NBFFLU,NBFECH,NBFRAY
      INTEGER NODES(NELEMS,NDMATS),NODEPR(NELEPR,NDMATS+1)
      INTEGER NPRIOS(NBPRIO,1+NBCOPR)
      INTEGER NFLUVS(NBFLVS)
      INTEGER NDIRS(NBDIRS)
      INTEGER NFFLUS(NBFFLU),NFECHS(NBFECH)
      INTEGER NFRAYS(NBFRAY),NFCOUS(NELEMS)
C
      DOUBLE PRECISION VFFLUS(NBFFLU,NDMATS),VFECHS(NBFECH,NDMATS,2)
      DOUBLE PRECISION VFRAYS(NBFRAY,NDMATS,2)
      DOUBLE PRECISION VFCOUS(NELEMS,NDMATS,2),TRAVF(NELEMS,NDMATS)
C
      DOUBLE PRECISION COORDS(NPOINS,NDIM),B(NPOINS)
      DOUBLE PRECISION XMAT(NELEMS,NCOEMA)
      DOUBLE PRECISION DMAT(NPOINS)
      DOUBLE PRECISION TMPS(NPOINS),TMPSA(NPOINS)
      DOUBLE PRECISION TMPSC1(NPOINS),TMPSC2(NPOINS)
      DOUBLE PRECISION TMPSC3(NPOINS)
      DOUBLE PRECISION PHYSOL(NPOINS,NBPHYS)
      DOUBLE PRECISION VFLUVS(NBFLVS)
      DOUBLE PRECISION VDIRS(NBDIRS)
      DOUBLE PRECISION DIAG(NPOINS),VOLUME(NELEMS)
      DOUBLE PRECISION TRAV1(NPOINS),TRAV2(NPOINS)
      DOUBLE PRECISION TRAV3(NPOINS),TRAV4(NPOINS)
      DOUBLE PRECISION WCT(NELEMS,NDMATS)
C
C..Variables locales
      INTEGER I,J,INODE,NF
      LOGICAL LVERIF
      DOUBLE PRECISION S2EP,EPAIS1,ZERO,SUR3,SUR5,ROCP1,RINDTS
      DOUBLE PRECISION HRAYO,SIG,SIGMA
C
C***********************************************************************
C     1- INITIALISATIONS
C     ==================
C
      LVERIF = .FALSE.
      ZERO   = 0.D0
      LCOSTA = .TRUE.
      SIGMA = 5.67D-8
      SIG = SIGMA*273.15**3
C
C
      CALL OV ( 'X=C     ',TRAVF,TRAVF,TRAVF,ZERO,NELEMS*NDMATS )
C     
C     2- CALCUL DE L'EQUATION SUR LE PREMIER COEFFICIENT
C     ==================================================
C
C
C     2.1- Calcul de la matrice de masse mass-lumpee
C          ----------------------------------------------
      DO 2101 J=1,NDMATS
        DO 2100 I=1,NELEMS
          NF = NFCOUS(I)
          INODE = NODES(NFCOUS(I),J)
          EPAIS1 = PHYSOL(INODE,6) / 2.D0
          TRAVF(NF,J) = (1.D0-EPAIS1*PHYSOL(INODE,5)) * VFCOUS(I,J,2)
 2100   CONTINUE
 2101 CONTINUE
C
      DO 2111 J=1,NDMATS
        DO 2110 I=1,NBFECH
          NF = NFECHS(I)
          INODE = NODES(NFECHS(I),J)
          EPAIS1 = PHYSOL(INODE,6) / 2.D0
          TRAVF(NF,J) = TRAVF(NF,J) + 
     &                 (1.D0+EPAIS1*PHYSOL(INODE,5)) * VFECHS(I,J,2)
 2110   CONTINUE
 2111 CONTINUE
C
      IF (.NOT. LCOSTA) THEN 
        RINDTS = 1.D0 / RDTTS
        DO 2121 J=1,NDMATS
          DO 2120 I=1,NELEMS
            INODE = NODES(I,J)
            ROCP1 = PHYSOL(INODE,1) * PHYSOL(INODE,2) * RINDTS
            TRAVF(I,J) = TRAVF(I,J) + ROCP1 * PHYSOL(INODE,6) 
 2120     CONTINUE
 2121   CONTINUE
      ENDIF
C
      DO 2131 J=1,NDMATS
        DO 2130 I=1,NBFRAY
          NF = NFRAYS(I)
          INODE = NODES(NFRAYS(I),J)
          EPAIS1 = PHYSOL(INODE,6) / 2.D0
          HRAYO = VFRAYS(I,J,2)*SIG*(TMPS(INODE)+VFRAYS(I,J,1))*
     &       (TMPS(INODE)*TMPS(INODE)+VFRAYS(I,J,1)*VFRAYS(I,J,1))
          TRAVF(NF,J) = TRAVF(NF,J) + 
     &                 (1.D0+EPAIS1*PHYSOL(INODE,5)) * HRAYO
 2130   CONTINUE
 2131 CONTINUE
C
       CALL MATEFC ('MASSE   ',DMAT,XMAT,TRAVF,NODES,COORDS,VOLUME, 
     &               NELEMS,NPOINS,NDMATS,NDIM,NDIELE,
     &               WCT )
C
C
C      2.2- Calcul du second membre
C      ----------------------------
C      cela comprend : 
C                         le flux couple au fluide
C                         le flux exterieur utilisateur
C                         le flux avec coefficient d'echange.
C                         le flux volumique constant dans l'epaisseur
C                         le second membre explicite (iteration n)
C
       CALL OV ( 'X=C     ',TRAVF,TRAVF,TRAVF,ZERO,NELEMS*NDMATS )
C
C  
C
      DO 2211 J=1,NDMATS
        DO 2210 I=1,NELEMS
           NF = NFCOUS(I)
           INODE = NODES(NFCOUS(I),J)
           EPAIS1 = PHYSOL(INODE,6) / 2.D0
           TRAVF(NF,J) =(1.D0-EPAIS1*PHYSOL(INODE,5))
     &                               * VFCOUS(I,J,2)
     &                               * VFCOUS(I,J,1)
 2210    CONTINUE
 2211  CONTINUE
C
      DO 2221 J=1,NDMATS
        DO 2220 I=1,NBFFLU
           NF = NFFLUS(I)
           INODE = NODES(NFFLUS(I),J)
           EPAIS1 = PHYSOL(INODE,6) / 2.D0
           TRAVF(NF,J) = TRAVF(NF,J) +
     &                   (1.D0+EPAIS1*PHYSOL(INODE,5))
     &                   * VFFLUS(I,J)
 2220   CONTINUE          
 2221 CONTINUE          
C
      DO 2231 J=1,NDMATS
        DO 2230 I=1,NBFECH
          NF = NFECHS(I)
          INODE = NODES(NFECHS(I),J)
          EPAIS1 = PHYSOL(INODE,6) / 2.D0
          TRAVF(NF,J) = TRAVF(NF,J) +
     &                   (1.D0+EPAIS1*PHYSOL(INODE,5))
     &                   * VFECHS(I,J,2) 
     &                   * VFECHS(I,J,1)
 2230   CONTINUE
 2231 CONTINUE
C
C
C
      CALL OV ( 'X=C     ',TRAV1,TRAV1,TRAV1,ZERO,NPOINS )
      DO 2240 I=1,NBFLVS
          INODE = NFLUVS(I)
          TRAV1(INODE) = VFLUVS(I) * PHYSOL(INODE,6)
 2240 CONTINUE
C      
C
      DO 2242 J=1,NDMATS
        DO 2241 I=1,NELEMS
          INODE = NODES(I,J)
          TRAVF(I,J) = TRAVF(I,J) + TRAV1(INODE)
 2241   CONTINUE
 2242 CONTINUE
C
C
C           
C
      DO 2251 J=1,NDMATS
        DO 2250 I=1,NELEMS
          NF = NFCOUS(I)
          INODE = NODES(NFCOUS(I),J)
          EPAIS1 = PHYSOL(INODE,6) * 0.5D0
          TRAVF(I,J) = TRAVF(I,J) 
     &               - (1.D0-EPAIS1*PHYSOL(INODE,5)) * VFCOUS(I,J,2)
     &               * ( - TMPSC2(INODE) + TMPSC3(INODE) )            
 2250   CONTINUE
 2251 CONTINUE
C
      DO 2261 J=1,NDMATS
        DO 2260 I=1,NBFECH
          NF = NFECHS(I)
          INODE = NODES(NFECHS(I),J)
          EPAIS1 = PHYSOL(INODE,6) * 0.5D0
          TRAVF(NF,J) = TRAVF(NF,J) 
     &               - (1.D0+EPAIS1*PHYSOL(INODE,5)) * VFECHS(I,J,2)
     &               * ( TMPSC2(INODE) + TMPSC3(INODE) )            
 2260   CONTINUE
 2261 CONTINUE
C
C     Prise en compte du terme explicite en T1 etape n
C     Terme de masse (en temps) pour tous les points (instationnaire)
      IF ( .NOT. LCOSTA ) THEN
        RINDTS = 1.D0 / RDTTS
        DO 2271 J=1,NDMATS
          DO 2270 I=1,NELEMS
            INODE = NODES(I,J)
            ROCP1 = PHYSOL(INODE,1) * PHYSOL(INODE,2) * RINDTS
            TRAVF(I,J) = TRAVF(I,J) + ROCP1 * PHYSOL(INODE,6)
     &                 * TMPSC1(INODE)
 2270     CONTINUE
 2271   CONTINUE
      ENDIF
C
      DO 2281 J=1,NDMATS
        DO 2280 I=1,NBFRAY
          NF = NFRAYS(I)
          INODE = NODES(NFRAYS(I),J)
          EPAIS1 = PHYSOL(INODE,6) * 0.5D0
          HRAYO = VFRAYS(I,J,2)*SIG*(TMPS(INODE)+VFRAYS(I,J,1))*
     &            (TMPS(INODE)*TMPS(INODE)+VFRAYS(I,J,1)*VFRAYS(I,J,1))
          TRAVF(NF,J) = TRAVF(NF,J) + 
     &                   (1.D0+EPAIS1*PHYSOL(INODE,5))
     &                   * HRAYO * VFRAYS(I,J,1)
 2280   CONTINUE
 2281 CONTINUE
C
C
       CALL SMFFCO ( TRAVF,B,NODES,VOLUME,
     &               NPOINS,NELEMS,NDMATS,NDIELE,
     &               WCT )
C
C
C      2.3- Calcul de la matrice de diffusion
C      --------------------------------------
C
        DO 2300 I=1,NPOINS
         TRAV1(I) =   PHYSOL(I,6) * PHYSOL(I,3)
 2300  CONTINUE
C
C      Calcul de la matrice complete
C      DMAT contient la matrice de masse assemblee
C      XMAT contient les termes extras diagonaux
       CALL MATELC ('DIFFU   ',DMAT,XMAT,TRAV1,NODES,COORDS,VOLUME, 
     &               NELEMS,NPOINS,NDMATS,NDIM,NDIELE,NCOEMA,
     &               WCT )
C
C
C
C      2.4- Resolution de la premiere equation
C      ---------------------------------------
C
        CALL OV ('X=1/Y   ',DIAG,DMAT,DMAT,ZERO,NPOINS )
C
        CALL GRCONJ ( TMPSC1,DMAT,XMAT,B,DIAG,NODES,
     &                TRAV1,TRAV2,TRAV3,TRAV4,WCT,
     &                NPOINS,NELEMS,NDIELE,NDMATS,NCOEMA,
     &                NODEPR,NELEPR,NPRIOS,NBPRIO,NBCOPR )
C      
C
C
C
C     3- CALCUL DE L'EQUATION SUR LE DEUXIEME COEFFICIENT
C     ==================================================
C
      CALL OV ( 'X=C     ',TRAVF,TRAVF,TRAVF,ZERO,NELEMS*NDMATS )
C
C     3.1- Calcul de la matrice de masse mass-lumpee
C     ----------------------------------------------
      S2EP = 2.D0 / EPAIS1
      DO 3101 J=1,NDMATS
        DO 3100 I=1,NELEMS
          NF = NFCOUS(I)
          INODE = NODES(NFCOUS(I),J)
          EPAIS1 = PHYSOL(INODE,6) * 0.5D0
          TRAVF(NF,J) = S2EP *  PHYSOL(INODE,4) +
     &               (1.D0-EPAIS1*PHYSOL(INODE,5)) * VFCOUS(I,J,2)          
 3100    CONTINUE
 3101 CONTINUE
C
      DO 3111 J=1,NDMATS
        DO 3110 I=1,NBFECH
          NF = NFECHS(I)
          INODE = NODES(NFECHS(I),J)
          EPAIS1 = PHYSOL(INODE,6) / 2.D0
          TRAVF(NF,J) =  TRAVF(NF,J)
     &                + (1.D0+EPAIS1*PHYSOL(INODE,5)) * VFECHS(I,J,2)         
 3110   CONTINUE
 3111 CONTINUE
C
      IF ( .NOT. LCOSTA ) THEN
        SUR3 = 1.D0 / 3.D0
        RINDTS = 1.D0 / RDTTS
        DO 3121 J=1,NDMATS
           DO 3120 I=1,NELEMS
             INODE = NODES(I,J)
             ROCP1 = PHYSOL(INODE,1) * PHYSOL(INODE,2) * RINDTS 
             TRAVF(I,J) =  TRAVF(I,J) + ROCP1 * SUR3 * PHYSOL(INODE,6)
 3120      CONTINUE
 3121   CONTINUE
      ENDIF
C
C
      DO 3131 J=1,NDMATS
        DO 3130 I=1,NBFRAY
          NF = NFRAYS(I)
          INODE = NODES(NFRAYS(I),J)
          EPAIS1 = PHYSOL(INODE,6) * 0.5D0
          HRAYO = VFRAYS(I,J,2)*SIG*(TMPS(INODE)+VFRAYS(I,J,1))*
     &            (TMPS(INODE)*TMPS(INODE)+VFRAYS(I,J,1)*VFRAYS(I,J,1))
          TRAVF(NF,J) = TRAVF(NF,J) +
     &                 (1.D0-EPAIS1*PHYSOL(INODE,5)) * HRAYO
 3130   CONTINUE
 3131 CONTINUE
C
         CALL MATEFC ('MASSE   ',DMAT,XMAT,TRAVF,NODES,COORDS,VOLUME, 
     &                 NELEMS,NPOINS,NDMATS,NDIM,NDIELE,
     &                 WCT )
C
C        3.2- Calcul de la matrice de diffusion
C        --------------------------------------
         S2EP =  1.D0 / 3.D0
         DO 3200 I=1,NPOINS
           TRAV1(I) =   S2EP * PHYSOL(I,3) * PHYSOL(I,6)
 3200    CONTINUE
C
         CALL MATELC ('DIFFU   ',DMAT,XMAT,TRAV1,NODES,COORDS,VOLUME, 
     &                 NELEMS,NPOINS,NDMATS,NDIM,NDIELE,NCOEMA,
     &                 WCT )
C
C
C        3.3- Calcul du second membre
C        ----------------------------
C        cela comprend : 
C                         la partie couplee au fluide
C                         la partie avec flux exterieur utilisateur
C                         la partie avec coefficient d'echange.
C                         le flux volumique constant dans l'epaisseur
C
         CALL OV ( 'X=C     ',TRAVF,TRAVF,TRAVF,ZERO,NELEMS*NDMATS )
C
C  
C
      DO 3311 J=1,NDMATS
        DO 3310 I=1,NELEMS
          NF = NFCOUS(I)
          INODE = NODES(NFCOUS(I),J)
          EPAIS1 = PHYSOL(INODE,6) / 2.D0
          TRAVF(NF,J) = - (1.D0-EPAIS1*PHYSOL(INODE,5))
     &                               * VFCOUS(I,J,2)
     &                               * VFCOUS(I,J,1)
 3310    CONTINUE
 3311  CONTINUE
C
      DO 3321 J=1,NDMATS
         DO 3320 I=1,NBFFLU
            NF = NFFLUS(I)
            INODE = NODES(NFFLUS(I),J)
            EPAIS1 = PHYSOL(INODE,6) / 2.D0
            TRAVF(NF,J) = TRAVF(NF,J)
     &                     + (1.D0+EPAIS1*PHYSOL(INODE,5))
     &                     * VFFLUS(I,J)
 3320   CONTINUE          
 3321 CONTINUE          
C
      DO 3331 J=1,NDMATS
        DO 3330 I=1,NBFECH
          NF = NFECHS(I)
          INODE = NODES(NFECHS(I),J)
          EPAIS1 = PHYSOL(INODE,6) / 2.D0
          TRAVF(NF,J) = TRAVF(NF,J)
     &                     + (1.D0+EPAIS1*PHYSOL(INODE,5))
     &                     * VFECHS(I,J,2)
     &                     * VFECHS(I,J,1)
 3330   CONTINUE
 3331 CONTINUE
C
      DO 3341 J=1,NDMATS
        DO 3340 I=1,NBFRAY
           NF = NFRAYS(I)
           INODE = NODES(NFRAYS(I),J)
           EPAIS1 = PHYSOL(INODE,6) / 2.D0
           HRAYO = VFRAYS(I,J,2)*SIG*(TMPS(INODE)+VFRAYS(I,J,1))*
     &           (TMPS(INODE)*TMPS(INODE)+VFRAYS(I,J,1)*VFRAYS(I,J,1))
           TRAVF(NF,J) = TRAVF(NF,J) 
     &                     + (1.D0+EPAIS1*PHYSOL(INODE,5))
     &                     * HRAYO
     &                     * VFRAYS(I,J,1)
 3340    CONTINUE
 3341 CONTINUE
C
      DO 3351 J=1,NDMATS
        DO 3350 I=1,NELEMS
          NF = NFCOUS(I)
          INODE = NODES(NFCOUS(I),J)
          EPAIS1 = PHYSOL(INODE,6) / 2.D0
          TRAVF(NF,J) = TRAVF(NF,J)
     &                     + (1.D0-EPAIS1*PHYSOL(INODE,5))
     &                        * VFCOUS(I,J,2)
     &                        * ( TMPSC1(INODE) + TMPSC3(INODE) )  
     &                     - 2.D0*PHYSOL(INODE,5)*PHYSOL(INODE,4)
     &                        * TMPSC3(INODE)         
 3350   CONTINUE
 3351 CONTINUE
C
      DO 3361 J=1,NDMATS
        DO 3360 I=1,NBFECH
          NF = NFECHS(I)
          INODE = NODES(NFECHS(I),J)
          EPAIS1 = PHYSOL(INODE,6) / 2.D0
          TRAVF(NF,J) = TRAVF(NF,J)
     &                     - (1.D0+EPAIS1*PHYSOL(INODE,5))
     &                     * VFECHS(I,J,2)
     &                     * ( TMPSC1(INODE) + TMPSC3(INODE) )           
 3360   CONTINUE
 3361 CONTINUE
C
      IF ( .NOT. LCOSTA ) THEN
        SUR3 = 1.D0 / 3.D0
        RINDTS = 1.D0 / RDTTS
        DO 3371 J=1,NDMATS
          DO 3370 I=1,NELEMS
            INODE = NODES(I,J)
            ROCP1 = PHYSOL(INODE,1) * PHYSOL(INODE,2) * RINDTS
            TRAVF(I,J) =  TRAVF(I,J) + ROCP1 * SUR3 *
     &                               PHYSOL(INODE,6) * TMPSC2(INODE)
 3370     CONTINUE
 3371   CONTINUE
      ENDIF
C
      DO 3381 J=1,NDMATS
        DO 3380 I=1,NBFRAY
          NF = NFRAYS(I)
          INODE = NODES(NFRAYS(I),J)
          EPAIS1 = PHYSOL(INODE,6) * 0.5D0
          HRAYO = VFRAYS(I,J,2)*SIG*(TMPS(INODE)+VFRAYS(I,J,1))*
     &           (TMPS(INODE)*TMPS(INODE)+VFRAYS(I,J,1)*VFRAYS(I,J,1))
          TRAVF(NF,J) = TRAVF(NF,J)
     &                 - (1.D0+EPAIS1*PHYSOL(INODE,5))
     &                 * HRAYO
     &                 * ( TMPSC1(INODE) + TMPSC3(INODE) )           
 3380   CONTINUE
 3381 CONTINUE
C
C
      CALL OV ( 'X=C     ',TRAV1,TRAV1,TRAV1,ZERO,NPOINS )
      DO 3390 I=1,NBFLVS
        INODE = NFLUVS(I)
        EPAIS1 = PHYSOL(INODE,6) / 2.D0
        TRAV1(INODE) = VFLUVS(I)
     &                 * 2.D0/3.D0 * EPAIS1 * EPAIS1
     &                 * ABS( PHYSOL(INODE,5) )
 3390 CONTINUE
C      
C
      DO 3392 J=1,NDMATS
        DO 3391 I=1,NELEMS
          INODE = NODES(I,J)
          TRAVF(I,J) = TRAVF(I,J) + TRAV1(INODE)
 3391   CONTINUE
 3392 CONTINUE
C
C
          CALL SMFFCO ( TRAVF,B,NODES,VOLUME,
     &                  NPOINS,NELEMS,NDMATS,NDIELE,
     &                  WCT )
C
C
C        3.4- Resolution de la deuxieme equation
C        ---------------------------------------
C
C
         CALL OV ('X=1/Y   ',DIAG,DMAT,DMAT,ZERO,NPOINS )
C
         CALL GRCONJ ( TMPSC2,DMAT,XMAT,B,DIAG,NODES,
     &                  TRAV1,TRAV2,TRAV3,TRAV4,WCT,
     &                  NPOINS,NELEMS,NDIELE,NDMATS,NCOEMA,
     &                  NODEPR,NELEPR,NPRIOS,NBPRIO,NBCOPR )
C      
C
C     4- CALCUL DE L'EQUATION SUR LE TROISIEME COEFFICIENT
C     ====================================================
C
C     On resout une equation de diffusion 
C
      CALL OV ( 'X=C     ',TRAVF,TRAVF,TRAVF,ZERO,NELEMS*NDMATS )
C
C     4.1- Calcul de la matrice de masse mass-lumpee
C     ----------------------------------------------
      S2EP = 6.D0 
      DO 4101 J=1,NDMATS
        DO 4100 I=1,NELEMS
          NF = NFCOUS(I)
          INODE = NODES(NFCOUS(I),J)
          EPAIS1 = PHYSOL(INODE,6) / 2.D0
          TRAVF(NF,J) = S2EP * PHYSOL(INODE,4) / EPAIS1   
     &                + (1.D0-EPAIS1*PHYSOL(INODE,5)) * VFCOUS(I,J,2)    
 4100   CONTINUE
 4101 CONTINUE
C
      DO 4111 J=1,NDMATS
        DO 4110 I=1,NBFECH
          NF = NFECHS(I)
          INODE = NODES(NFECHS(I),J)
          EPAIS1 = PHYSOL(INODE,6) / 2.D0
          TRAVF(NF,J) =  TRAVF(NF,J)
     &                + (1.D0+EPAIS1*PHYSOL(INODE,5)) * VFECHS(I,J,2)     
 4110    CONTINUE
 4111 CONTINUE
C
      IF ( .NOT. LCOSTA) THEN
        SUR5 = 1.D0 / 5.D0
        RINDTS = 1.D0 / RDTTS
        DO 4121 J=1,NDMATS
          DO 4120 I=1,NELEMS
            INODE = NODES(I,J)
            ROCP1 = PHYSOL(INODE,1) * PHYSOL(INODE,2) * RINDTS
            TRAVF(I,J) = TRAVF(I,J) + ROCP1 * SUR5 * PHYSOL(INODE,6)
 4120     CONTINUE
 4121   CONTINUE
      ENDIF
C
      DO 4131 J=1,NDMATS
        DO 4130 I=1,NBFRAY
          NF = NFRAYS(I)
          INODE = NODES(NFRAYS(I),J)
          EPAIS1 = PHYSOL(INODE,6) / 2.D0
          HRAYO = VFRAYS(I,J,2)*SIG*(TMPS(INODE)+VFRAYS(I,J,1))*
     &           (TMPS(INODE)*TMPS(INODE)+VFRAYS(I,J,1)*VFRAYS(I,J,1))
          TRAVF(NF,J) = TRAVF(NF,J) +
     &                 (1.D0-EPAIS1*PHYSOL(INODE,5)) * HRAYO
 4130   CONTINUE
 4131 CONTINUE
C
         CALL MATEFC ('MASSE   ',DMAT,XMAT,TRAVF,NODES,COORDS,VOLUME, 
     &                 NELEMS,NPOINS,NDMATS,NDIM,NDIELE,
     &                 WCT )
C
C        4.2- Calcul de la matrice de diffusion
C        --------------------------------------
         S2EP =  1.D0 / 5.D0 
         DO 4200 I=1,NPOINS
           TRAV1(I) =   S2EP * PHYSOL(I,3) * PHYSOL(I,6)
 4200    CONTINUE
C
         CALL MATELC ('DIFFU   ',DMAT,XMAT,TRAV1,NODES,COORDS,VOLUME, 
     &                 NELEMS,NPOINS,NDMATS,NDIM,NDIELE,NCOEMA,
     &                 WCT )
C
C
C        4.3- Calcul du second membre
C        ----------------------------
C        cela comprend : 
C                         la partie couplee au fluide
C                         la partie avec flux exterieur utilisateur
C                         la partie avec coefficient d'echange.
C                         le flux volumique constant dans l'epaisseur
C
C
         CALL OV ( 'X=C     ',TRAVF,TRAVF,TRAVF,ZERO,NELEMS*NDMATS )
C
C  
      IF ( .NOT. LCOSTA ) THEN
        SUR5 = 1.D0 / 5.D0
        RINDTS = 1.D0 / RDTTS
        DO 4301 J=1,NDMATS
          DO 4300 I=1,NELEMS
            INODE = NODES(I,J)
            ROCP1 = PHYSOL(INODE,1) * PHYSOL(INODE,2) * RINDTS
            TRAVF(I,J) =  TRAVF(I,J) + ROCP1 * SUR5
     &                             * PHYSOL(INODE,6) * TMPSC3(INODE)
 4300     CONTINUE
 4301   CONTINUE
      ENDIF
C
C
      DO 4311 J=1,NDMATS
        DO 4310 I=1,NELEMS
          NF = NFCOUS(I)
          INODE = NODES(NFCOUS(I),J)
          EPAIS1 =  PHYSOL(INODE,6) * 0.5D0
          TRAVF(NF,J) = (1.D0-EPAIS1*PHYSOL(INODE,5))
     &                  * VFCOUS(I,J,2)
     &                  * VFCOUS(I,J,1)
 4310   CONTINUE
 4311 CONTINUE
C
      DO 4321 J=1,NDMATS
        DO 4320 I=1,NBFFLU
          NF = NFFLUS(I) 
          INODE = NODES(NFFLUS(I),J)
          EPAIS1 =  PHYSOL(INODE,6) / 2.D0
          TRAVF(NF,J) = TRAVF(NF,J)
     &                 + (1.D0+EPAIS1*PHYSOL(INODE,5))
     &                 * VFFLUS(I,J)                  
 4320   CONTINUE          
 4321 CONTINUE          
C
      DO 4331 J=1,NDMATS
        DO 4330 I=1,NBFECH
          NF = NFECHS(I)
          INODE = NODES(NFECHS(I),J)
          EPAIS1 =  PHYSOL(INODE,6) / 2.D0
          TRAVF(NF,J) = TRAVF(NF,J)
     &                + (1.D0+EPAIS1*PHYSOL(INODE,5))
     &                * VFECHS(I,J,2)
     &                * VFECHS(I,J,1)
 4330   CONTINUE
 4331 CONTINUE
C
      DO 4341 J=1,NDMATS
         DO 4340 I=1,NBFRAY
            NF = NFRAYS(I)
            INODE = NODES(NFRAYS(I),J)
            EPAIS1 =  PHYSOL(INODE,6) / 2.D0
            HRAYO = VFRAYS(I,J,2)*SIG*(TMPS(INODE)+VFRAYS(I,J,1))*
     &           (TMPS(INODE)*TMPS(INODE)+VFRAYS(I,J,1)*VFRAYS(I,J,1))
            TRAVF(NF,J) = TRAVF(NF,J) 
     &                     + (1.D0+EPAIS1*PHYSOL(INODE,5))
     &                     * HRAYO
     &                     * VFRAYS(I,J,1)
 4340    CONTINUE
 4341 CONTINUE
C
C
C
      DO 4351 J=1,NDMATS
        DO 4350 I=1,NELEMS
          NF = NFCOUS(I)
          INODE = NODES(NFCOUS(I),J)
          EPAIS1 =  PHYSOL(INODE,6)* 0.5D0
          TRAVF(NF,J) = TRAVF(NF,J)
     &                 - (1.D0-EPAIS1*PHYSOL(INODE,5))
     &                 * ( -TMPSC2(INODE) + TMPSC1(INODE) )
     &                 * VFCOUS(I,J,2)
     &                 - 2.D0*PHYSOL(INODE,5)*PHYSOL(INODE,4)
     &                 * TMPSC2(INODE)
 4350    CONTINUE
 4351 CONTINUE
C
      DO 4361 J=1,NDMATS
        DO 4360 I=1,NBFECH
          NF = NFECHS(I)
          INODE = NODES(NFECHS(I),J)
          EPAIS1 =  PHYSOL(INODE,6) * 0.5D0
          TRAVF(NF,J) = TRAVF(NF,J)
     &                - (1.D0+EPAIS1*PHYSOL(INODE,5))
     &                * VFECHS(I,J,2)
     &                * ( TMPSC2(INODE) + TMPSC1(INODE) )
 4360   CONTINUE
 4361 CONTINUE
C
      DO 4371 J=1,NDMATS
        DO 4370 I=1,NBFRAY
          NF = NFRAYS(I)
          INODE = NODES(NFRAYS(I),J)
          EPAIS1 =  PHYSOL(INODE,6) * 0.5D0
          HRAYO = VFRAYS(I,J,2)*SIG*(TMPS(INODE)+VFRAYS(I,J,1))*
     &          (TMPS(INODE)*TMPS(INODE)+VFRAYS(I,J,1)*VFRAYS(I,J,1))
          TRAVF(NF,J) = TRAVF(NF,J)
     &                 - (1.D0-EPAIS1*PHYSOL(INODE,5))
     &                 * ( -TMPSC2(INODE) + TMPSC1(INODE) )
     &                 * HRAYO
c     &                 - 2.D0*PHYSOL(INODE,5)*PHYSOL(INODE,4)
c     &                 * TMPSC2(INODE)
 4370    CONTINUE
 4371 CONTINUE
C
         CALL SMFFCO ( TRAVF,B,NODES,VOLUME,
     &                 NPOINS,NELEMS,NDMATS,NDIELE,
     &                 WCT )
C
C
C
C
         DO 438 I=1,NBDIRS
         VDIRS(I) = VDIRS(I) - TMPSC1(NDIRS(I)) 
     &                       + TMPSC2(NDIRS(I))
  438       CONTINUE
C
C
         IF ( NBDIRS .GT. 0 ) THEN
         CALL SMDIRS ( NDIRS,VDIRS,B,DMAT,XMAT,NODES,
     &                 TRAV1,TRAV2,TRAV3,
     &                 NPOINS,NELEMS,NDMATS,NBDIRS,NCOEMA,
     &                 NDIELE,NODEPR,NELEPR,NPRIOS,NBPRIO,NBCOPR,
     &                 WCT ) 
         ENDIF
C
C        4.4- Resolution de la Troisieme equation
C        ---------------------------------------
C
         CALL OV ('X=1/Y   ',DIAG,DMAT,DMAT,ZERO,NPOINS )
C
         CALL GRCONJ ( TMPSC3,DMAT,XMAT,B,DIAG,NODES,
     &                 TRAV1,TRAV2,TRAV3,TRAV4,WCT,
     &                 NPOINS,NELEMS,NDIELE,NDMATS,NCOEMA,
     &                 NODEPR,NELEPR,NPRIOS,NBPRIO,NBCOPR )
C      
C
C     5- CALCUL DE LA TEMPERATURE SUR LES DEUX FACES INT ET EXT
C     =========================================================
C
C     5.1 Calcul du point interieur
C     -----------------------------
      DO 510 I=1,NPOINS
          TMPSA(I) = TMPSC1(I) - TMPSC2(I) + TMPSC3(I)
 510  CONTINUE
C
C     5.2 Calcul du point exterieur
C     -----------------------------
      DO 520 I=1,NPOINS
          TMPS(I) = TMPSC1(I) + TMPSC2(I) + TMPSC3(I)
 520  CONTINUE
C
      END
