function(append value)
  foreach(variable ${ARGN})
    set(${variable} "${${variable}} ${value}" PARENT_SCOPE)
  endforeach(variable)
endfunction()

include(CheckCXXCompilerFlag)

if (NOT DEFINED SDCV_COMPILER_IS_GCC_COMPATIBLE)
  if (CMAKE_COMPILER_IS_GNUCXX)
    set(SDCV_COMPILER_IS_GCC_COMPATIBLE ON)
  elseif (MSVC)
    set(SDCV_COMPILER_IS_GCC_COMPATIBLE OFF)
  elseif ("${CMAKE_CXX_COMPILER_ID}" MATCHES "Clang")
    set (SDCV_COMPILER_IS_GCC_COMPATIBLE ON)
  endif()
endif()

if (MSVC AND (MSVC_VERSION LESS 1900))
  message(FATAL_ERROR "MSVC version ${MSVC_VERSION} have no full c++11 support")
elseif (MSVC)
  add_definitions(-DNOMINMAX)
elseif (NOT MSVC)
  check_cxx_compiler_flag("-std=c++11" CXX_SUPPORTS_CXX11)
  if (CXX_SUPPORTS_CXX11)
    append("-std=c++11" CMAKE_CXX_FLAGS)
  else ()
    message(FATAL_ERROR "sdcv requires C++11 support but the '-std=c++11' flag isn't supported.")
  endif()
endif ()

if (SDCV_COMPILER_IS_GCC_COMPATIBLE)
  append("-Wall" "-Wextra" "-Wformat-security" "-Wcast-align" "-Werror=format" "-Wcast-qual" CMAKE_C_FLAGS)
  append("-Wall" "-pedantic" "-Wextra" "-Wformat-security" "-Wcast-align" "-Werror=format" "-Wcast-qual" CMAKE_CXX_FLAGS)
endif ()
