/*************************************************************************
 * odil - Copyright (C) Universite de Strasbourg
 * Distributed under the terms of the CeCILL-B license, as published by
 * the CEA-CNRS-INRIA. Refer to the LICENSE file or to
 * http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html
 * for details.
 ************************************************************************/

#include <map>
#include <string>
#include <tuple>

#include "odil/ElementsDictionary.h"
#include "odil/Tag.h"

namespace odil
{

namespace registry
{

void update_0008(
    ElementsDictionary & public_dictionary,
    std::map<std::string, odil::Tag> & public_tags)
{

    public_dictionary.emplace(Tag(0x0008, 0x0001), ElementsDictionaryEntry("Length to End", "LengthToEnd",  "UL", "1"));
    public_dictionary.emplace(Tag(0x0008, 0x0005), ElementsDictionaryEntry("Specific Character Set", "SpecificCharacterSet",  "CS", "1-n"));
    public_dictionary.emplace(Tag(0x0008, 0x0006), ElementsDictionaryEntry("Language Code Sequence", "LanguageCodeSequence",  "SQ", "1"));
    public_dictionary.emplace(Tag(0x0008, 0x0008), ElementsDictionaryEntry("Image Type", "ImageType",  "CS", "2-n"));
    public_dictionary.emplace(Tag(0x0008, 0x0010), ElementsDictionaryEntry("Recognition Code", "RecognitionCode",  "SH", "1"));
    public_dictionary.emplace(Tag(0x0008, 0x0012), ElementsDictionaryEntry("Instance Creation Date", "InstanceCreationDate",  "DA", "1"));
    public_dictionary.emplace(Tag(0x0008, 0x0013), ElementsDictionaryEntry("Instance Creation Time", "InstanceCreationTime",  "TM", "1"));
    public_dictionary.emplace(Tag(0x0008, 0x0014), ElementsDictionaryEntry("Instance Creator UID", "InstanceCreatorUID",  "UI", "1"));
    public_dictionary.emplace(Tag(0x0008, 0x0015), ElementsDictionaryEntry("Instance Coercion DateTime", "InstanceCoercionDateTime",  "DT", "1"));
    public_dictionary.emplace(Tag(0x0008, 0x0016), ElementsDictionaryEntry("SOP Class UID", "SOPClassUID",  "UI", "1"));
    public_dictionary.emplace(Tag(0x0008, 0x0017), ElementsDictionaryEntry("Acquisition UID", "AcquisitionUID",  "UI", "1"));
    public_dictionary.emplace(Tag(0x0008, 0x0018), ElementsDictionaryEntry("SOP Instance UID", "SOPInstanceUID",  "UI", "1"));
    public_dictionary.emplace(Tag(0x0008, 0x0019), ElementsDictionaryEntry("Pyramid UID", "PyramidUID",  "UI", "1"));
    public_dictionary.emplace(Tag(0x0008, 0x001a), ElementsDictionaryEntry("Related General SOP Class UID", "RelatedGeneralSOPClassUID",  "UI", "1-n"));
    public_dictionary.emplace(Tag(0x0008, 0x001b), ElementsDictionaryEntry("Original Specialized SOP Class UID", "OriginalSpecializedSOPClassUID",  "UI", "1"));
    public_dictionary.emplace(Tag(0x0008, 0x0020), ElementsDictionaryEntry("Study Date", "StudyDate",  "DA", "1"));
    public_dictionary.emplace(Tag(0x0008, 0x0021), ElementsDictionaryEntry("Series Date", "SeriesDate",  "DA", "1"));
    public_dictionary.emplace(Tag(0x0008, 0x0022), ElementsDictionaryEntry("Acquisition Date", "AcquisitionDate",  "DA", "1"));
    public_dictionary.emplace(Tag(0x0008, 0x0023), ElementsDictionaryEntry("Content Date", "ContentDate",  "DA", "1"));
    public_dictionary.emplace(Tag(0x0008, 0x0024), ElementsDictionaryEntry("Overlay Date", "OverlayDate",  "DA", "1"));
    public_dictionary.emplace(Tag(0x0008, 0x0025), ElementsDictionaryEntry("Curve Date", "CurveDate",  "DA", "1"));
    public_dictionary.emplace(Tag(0x0008, 0x002a), ElementsDictionaryEntry("Acquisition DateTime", "AcquisitionDateTime",  "DT", "1"));
    public_dictionary.emplace(Tag(0x0008, 0x0030), ElementsDictionaryEntry("Study Time", "StudyTime",  "TM", "1"));
    public_dictionary.emplace(Tag(0x0008, 0x0031), ElementsDictionaryEntry("Series Time", "SeriesTime",  "TM", "1"));
    public_dictionary.emplace(Tag(0x0008, 0x0032), ElementsDictionaryEntry("Acquisition Time", "AcquisitionTime",  "TM", "1"));
    public_dictionary.emplace(Tag(0x0008, 0x0033), ElementsDictionaryEntry("Content Time", "ContentTime",  "TM", "1"));
    public_dictionary.emplace(Tag(0x0008, 0x0034), ElementsDictionaryEntry("Overlay Time", "OverlayTime",  "TM", "1"));
    public_dictionary.emplace(Tag(0x0008, 0x0035), ElementsDictionaryEntry("Curve Time", "CurveTime",  "TM", "1"));
    public_dictionary.emplace(Tag(0x0008, 0x0040), ElementsDictionaryEntry("Data Set Type", "DataSetType",  "US", "1"));
    public_dictionary.emplace(Tag(0x0008, 0x0041), ElementsDictionaryEntry("Data Set Subtype", "DataSetSubtype",  "LO", "1"));
    public_dictionary.emplace(Tag(0x0008, 0x0042), ElementsDictionaryEntry("Nuclear Medicine Series Type", "NuclearMedicineSeriesType",  "CS", "1"));
    public_dictionary.emplace(Tag(0x0008, 0x0050), ElementsDictionaryEntry("Accession Number", "AccessionNumber",  "SH", "1"));
    public_dictionary.emplace(Tag(0x0008, 0x0051), ElementsDictionaryEntry("Issuer of Accession Number Sequence", "IssuerOfAccessionNumberSequence",  "SQ", "1"));
    public_dictionary.emplace(Tag(0x0008, 0x0052), ElementsDictionaryEntry("Query/Retrieve Level", "QueryRetrieveLevel",  "CS", "1"));
    public_dictionary.emplace(Tag(0x0008, 0x0053), ElementsDictionaryEntry("Query/Retrieve View", "QueryRetrieveView",  "CS", "1"));
    public_dictionary.emplace(Tag(0x0008, 0x0054), ElementsDictionaryEntry("Retrieve AE Title", "RetrieveAETitle",  "AE", "1-n"));
    public_dictionary.emplace(Tag(0x0008, 0x0055), ElementsDictionaryEntry("Station AE Title", "StationAETitle",  "AE", "1"));
    public_dictionary.emplace(Tag(0x0008, 0x0056), ElementsDictionaryEntry("Instance Availability", "InstanceAvailability",  "CS", "1"));
    public_dictionary.emplace(Tag(0x0008, 0x0058), ElementsDictionaryEntry("Failed SOP Instance UID List", "FailedSOPInstanceUIDList",  "UI", "1-n"));
    public_dictionary.emplace(Tag(0x0008, 0x0060), ElementsDictionaryEntry("Modality", "Modality",  "CS", "1"));
    public_dictionary.emplace(Tag(0x0008, 0x0061), ElementsDictionaryEntry("Modalities in Study", "ModalitiesInStudy",  "CS", "1-n"));
    public_dictionary.emplace(Tag(0x0008, 0x0062), ElementsDictionaryEntry("SOP Classes in Study", "SOPClassesInStudy",  "UI", "1-n"));
    public_dictionary.emplace(Tag(0x0008, 0x0063), ElementsDictionaryEntry("Anatomic Regions in Study Code Sequence", "AnatomicRegionsInStudyCodeSequence",  "SQ", "1"));
    public_dictionary.emplace(Tag(0x0008, 0x0064), ElementsDictionaryEntry("Conversion Type", "ConversionType",  "CS", "1"));
    public_dictionary.emplace(Tag(0x0008, 0x0068), ElementsDictionaryEntry("Presentation Intent Type", "PresentationIntentType",  "CS", "1"));
    public_dictionary.emplace(Tag(0x0008, 0x0070), ElementsDictionaryEntry("Manufacturer", "Manufacturer",  "LO", "1"));
    public_dictionary.emplace(Tag(0x0008, 0x0080), ElementsDictionaryEntry("Institution Name", "InstitutionName",  "LO", "1"));
    public_dictionary.emplace(Tag(0x0008, 0x0081), ElementsDictionaryEntry("Institution Address", "InstitutionAddress",  "ST", "1"));
    public_dictionary.emplace(Tag(0x0008, 0x0082), ElementsDictionaryEntry("Institution Code Sequence", "InstitutionCodeSequence",  "SQ", "1"));
    public_dictionary.emplace(Tag(0x0008, 0x0090), ElementsDictionaryEntry("Referring Physician's Name", "ReferringPhysicianName",  "PN", "1"));
    public_dictionary.emplace(Tag(0x0008, 0x0092), ElementsDictionaryEntry("Referring Physician's Address", "ReferringPhysicianAddress",  "ST", "1"));
    public_dictionary.emplace(Tag(0x0008, 0x0094), ElementsDictionaryEntry("Referring Physician's Telephone Numbers", "ReferringPhysicianTelephoneNumbers",  "SH", "1-n"));
    public_dictionary.emplace(Tag(0x0008, 0x0096), ElementsDictionaryEntry("Referring Physician Identification Sequence", "ReferringPhysicianIdentificationSequence",  "SQ", "1"));
    public_dictionary.emplace(Tag(0x0008, 0x009c), ElementsDictionaryEntry("Consulting Physician's Name", "ConsultingPhysicianName",  "PN", "1-n"));
    public_dictionary.emplace(Tag(0x0008, 0x009d), ElementsDictionaryEntry("Consulting Physician Identification Sequence", "ConsultingPhysicianIdentificationSequence",  "SQ", "1"));
    public_dictionary.emplace(Tag(0x0008, 0x0100), ElementsDictionaryEntry("Code Value", "CodeValue",  "SH", "1"));
    public_dictionary.emplace(Tag(0x0008, 0x0101), ElementsDictionaryEntry("Extended Code Value", "ExtendedCodeValue",  "LO", "1"));
    public_dictionary.emplace(Tag(0x0008, 0x0102), ElementsDictionaryEntry("Coding Scheme Designator", "CodingSchemeDesignator",  "SH", "1"));
    public_dictionary.emplace(Tag(0x0008, 0x0103), ElementsDictionaryEntry("Coding Scheme Version", "CodingSchemeVersion",  "SH", "1"));
    public_dictionary.emplace(Tag(0x0008, 0x0104), ElementsDictionaryEntry("Code Meaning", "CodeMeaning",  "LO", "1"));
    public_dictionary.emplace(Tag(0x0008, 0x0105), ElementsDictionaryEntry("Mapping Resource", "MappingResource",  "CS", "1"));
    public_dictionary.emplace(Tag(0x0008, 0x0106), ElementsDictionaryEntry("Context Group Version", "ContextGroupVersion",  "DT", "1"));
    public_dictionary.emplace(Tag(0x0008, 0x0107), ElementsDictionaryEntry("Context Group Local Version", "ContextGroupLocalVersion",  "DT", "1"));
    public_dictionary.emplace(Tag(0x0008, 0x0108), ElementsDictionaryEntry("Extended Code Meaning", "ExtendedCodeMeaning",  "LT", "1"));
    public_dictionary.emplace(Tag(0x0008, 0x0109), ElementsDictionaryEntry("Coding Scheme Resources Sequence", "CodingSchemeResourcesSequence",  "SQ", "1"));
    public_dictionary.emplace(Tag(0x0008, 0x010a), ElementsDictionaryEntry("Coding Scheme URL Type", "CodingSchemeURLType",  "CS", "1"));
    public_dictionary.emplace(Tag(0x0008, 0x010b), ElementsDictionaryEntry("Context Group Extension Flag", "ContextGroupExtensionFlag",  "CS", "1"));
    public_dictionary.emplace(Tag(0x0008, 0x010c), ElementsDictionaryEntry("Coding Scheme UID", "CodingSchemeUID",  "UI", "1"));
    public_dictionary.emplace(Tag(0x0008, 0x010d), ElementsDictionaryEntry("Context Group Extension Creator UID", "ContextGroupExtensionCreatorUID",  "UI", "1"));
    public_dictionary.emplace(Tag(0x0008, 0x010e), ElementsDictionaryEntry("Coding Scheme URL", "CodingSchemeURL",  "UR", "1"));
    public_dictionary.emplace(Tag(0x0008, 0x010f), ElementsDictionaryEntry("Context Identifier", "ContextIdentifier",  "CS", "1"));
    public_dictionary.emplace(Tag(0x0008, 0x0110), ElementsDictionaryEntry("Coding Scheme Identification Sequence", "CodingSchemeIdentificationSequence",  "SQ", "1"));
    public_dictionary.emplace(Tag(0x0008, 0x0112), ElementsDictionaryEntry("Coding Scheme Registry", "CodingSchemeRegistry",  "LO", "1"));
    public_dictionary.emplace(Tag(0x0008, 0x0114), ElementsDictionaryEntry("Coding Scheme External ID", "CodingSchemeExternalID",  "ST", "1"));
    public_dictionary.emplace(Tag(0x0008, 0x0115), ElementsDictionaryEntry("Coding Scheme Name", "CodingSchemeName",  "ST", "1"));
    public_dictionary.emplace(Tag(0x0008, 0x0116), ElementsDictionaryEntry("Coding Scheme Responsible Organization", "CodingSchemeResponsibleOrganization",  "ST", "1"));
    public_dictionary.emplace(Tag(0x0008, 0x0117), ElementsDictionaryEntry("Context UID", "ContextUID",  "UI", "1"));
    public_dictionary.emplace(Tag(0x0008, 0x0118), ElementsDictionaryEntry("Mapping Resource UID", "MappingResourceUID",  "UI", "1"));
    public_dictionary.emplace(Tag(0x0008, 0x0119), ElementsDictionaryEntry("Long Code Value", "LongCodeValue",  "UC", "1"));
    public_dictionary.emplace(Tag(0x0008, 0x0120), ElementsDictionaryEntry("URN Code Value", "URNCodeValue",  "UR", "1"));
    public_dictionary.emplace(Tag(0x0008, 0x0121), ElementsDictionaryEntry("Equivalent Code Sequence", "EquivalentCodeSequence",  "SQ", "1"));
    public_dictionary.emplace(Tag(0x0008, 0x0122), ElementsDictionaryEntry("Mapping Resource Name", "MappingResourceName",  "LO", "1"));
    public_dictionary.emplace(Tag(0x0008, 0x0123), ElementsDictionaryEntry("Context Group Identification Sequence", "ContextGroupIdentificationSequence",  "SQ", "1"));
    public_dictionary.emplace(Tag(0x0008, 0x0124), ElementsDictionaryEntry("Mapping Resource Identification Sequence", "MappingResourceIdentificationSequence",  "SQ", "1"));
    public_dictionary.emplace(Tag(0x0008, 0x0201), ElementsDictionaryEntry("Timezone Offset From UTC", "TimezoneOffsetFromUTC",  "SH", "1"));
    public_dictionary.emplace(Tag(0x0008, 0x0220), ElementsDictionaryEntry("Responsible Group Code Sequence", "ResponsibleGroupCodeSequence",  "SQ", "1"));
    public_dictionary.emplace(Tag(0x0008, 0x0221), ElementsDictionaryEntry("Equipment Modality", "EquipmentModality",  "CS", "1"));
    public_dictionary.emplace(Tag(0x0008, 0x0222), ElementsDictionaryEntry("Manufacturer's Related Model Group", "ManufacturerRelatedModelGroup",  "LO", "1"));
    public_dictionary.emplace(Tag(0x0008, 0x0300), ElementsDictionaryEntry("Private Data Element Characteristics Sequence", "PrivateDataElementCharacteristicsSequence",  "SQ", "1"));
    public_dictionary.emplace(Tag(0x0008, 0x0301), ElementsDictionaryEntry("Private Group Reference", "PrivateGroupReference",  "US", "1"));
    public_dictionary.emplace(Tag(0x0008, 0x0302), ElementsDictionaryEntry("Private Creator Reference", "PrivateCreatorReference",  "LO", "1"));
    public_dictionary.emplace(Tag(0x0008, 0x0303), ElementsDictionaryEntry("Block Identifying Information Status", "BlockIdentifyingInformationStatus",  "CS", "1"));
    public_dictionary.emplace(Tag(0x0008, 0x0304), ElementsDictionaryEntry("Nonidentifying Private Elements", "NonidentifyingPrivateElements",  "US", "1-n"));
    public_dictionary.emplace(Tag(0x0008, 0x0306), ElementsDictionaryEntry("Identifying Private Elements", "IdentifyingPrivateElements",  "US", "1-n"));
    public_dictionary.emplace(Tag(0x0008, 0x0305), ElementsDictionaryEntry("Deidentification Action Sequence", "DeidentificationActionSequence",  "SQ", "1"));
    public_dictionary.emplace(Tag(0x0008, 0x0307), ElementsDictionaryEntry("Deidentification Action", "DeidentificationAction",  "CS", "1"));
    public_dictionary.emplace(Tag(0x0008, 0x0308), ElementsDictionaryEntry("Private Data Element", "PrivateDataElement",  "US", "1"));
    public_dictionary.emplace(Tag(0x0008, 0x0309), ElementsDictionaryEntry("Private Data Element Value Multiplicity", "PrivateDataElementValueMultiplicity",  "UL", "1-3"));
    public_dictionary.emplace(Tag(0x0008, 0x030a), ElementsDictionaryEntry("Private Data Element Value Representation", "PrivateDataElementValueRepresentation",  "CS", "1"));
    public_dictionary.emplace(Tag(0x0008, 0x030b), ElementsDictionaryEntry("Private Data Element Number of Items", "PrivateDataElementNumberOfItems",  "UL", "1-2"));
    public_dictionary.emplace(Tag(0x0008, 0x030c), ElementsDictionaryEntry("Private Data Element Name", "PrivateDataElementName",  "UC", "1"));
    public_dictionary.emplace(Tag(0x0008, 0x030d), ElementsDictionaryEntry("Private Data Element Keyword", "PrivateDataElementKeyword",  "UC", "1"));
    public_dictionary.emplace(Tag(0x0008, 0x030e), ElementsDictionaryEntry("Private Data Element Description", "PrivateDataElementDescription",  "UT", "1"));
    public_dictionary.emplace(Tag(0x0008, 0x030f), ElementsDictionaryEntry("Private Data Element Encoding", "PrivateDataElementEncoding",  "UT", "1"));
    public_dictionary.emplace(Tag(0x0008, 0x0310), ElementsDictionaryEntry("Private Data Element Definition Sequence", "PrivateDataElementDefinitionSequence",  "SQ", "1"));
    public_dictionary.emplace(Tag(0x0008, 0x1000), ElementsDictionaryEntry("Network ID", "NetworkID",  "AE", "1"));
    public_dictionary.emplace(Tag(0x0008, 0x1010), ElementsDictionaryEntry("Station Name", "StationName",  "SH", "1"));
    public_dictionary.emplace(Tag(0x0008, 0x1030), ElementsDictionaryEntry("Study Description", "StudyDescription",  "LO", "1"));
    public_dictionary.emplace(Tag(0x0008, 0x1032), ElementsDictionaryEntry("Procedure Code Sequence", "ProcedureCodeSequence",  "SQ", "1"));
    public_dictionary.emplace(Tag(0x0008, 0x103e), ElementsDictionaryEntry("Series Description", "SeriesDescription",  "LO", "1"));
    public_dictionary.emplace(Tag(0x0008, 0x103f), ElementsDictionaryEntry("Series Description Code Sequence", "SeriesDescriptionCodeSequence",  "SQ", "1"));
    public_dictionary.emplace(Tag(0x0008, 0x1040), ElementsDictionaryEntry("Institutional Department Name", "InstitutionalDepartmentName",  "LO", "1"));
    public_dictionary.emplace(Tag(0x0008, 0x1041), ElementsDictionaryEntry("Institutional Department Type Code Sequence", "InstitutionalDepartmentTypeCodeSequence",  "SQ", "1"));
    public_dictionary.emplace(Tag(0x0008, 0x1048), ElementsDictionaryEntry("Physician(s) of Record", "PhysiciansOfRecord",  "PN", "1-n"));
    public_dictionary.emplace(Tag(0x0008, 0x1049), ElementsDictionaryEntry("Physician(s) of Record Identification Sequence", "PhysiciansOfRecordIdentificationSequence",  "SQ", "1"));
    public_dictionary.emplace(Tag(0x0008, 0x1050), ElementsDictionaryEntry("Performing Physician's Name", "PerformingPhysicianName",  "PN", "1-n"));
    public_dictionary.emplace(Tag(0x0008, 0x1052), ElementsDictionaryEntry("Performing Physician Identification Sequence", "PerformingPhysicianIdentificationSequence",  "SQ", "1"));
    public_dictionary.emplace(Tag(0x0008, 0x1060), ElementsDictionaryEntry("Name of Physician(s) Reading Study", "NameOfPhysiciansReadingStudy",  "PN", "1-n"));
    public_dictionary.emplace(Tag(0x0008, 0x1062), ElementsDictionaryEntry("Physician(s) Reading Study Identification Sequence", "PhysiciansReadingStudyIdentificationSequence",  "SQ", "1"));
    public_dictionary.emplace(Tag(0x0008, 0x1070), ElementsDictionaryEntry("Operators' Name", "OperatorsName",  "PN", "1-n"));
    public_dictionary.emplace(Tag(0x0008, 0x1072), ElementsDictionaryEntry("Operator Identification Sequence", "OperatorIdentificationSequence",  "SQ", "1"));
    public_dictionary.emplace(Tag(0x0008, 0x1080), ElementsDictionaryEntry("Admitting Diagnoses Description", "AdmittingDiagnosesDescription",  "LO", "1-n"));
    public_dictionary.emplace(Tag(0x0008, 0x1084), ElementsDictionaryEntry("Admitting Diagnoses Code Sequence", "AdmittingDiagnosesCodeSequence",  "SQ", "1"));
    public_dictionary.emplace(Tag(0x0008, 0x1088), ElementsDictionaryEntry("Pyramid Description", "PyramidDescription",  "LO", "1"));
    public_dictionary.emplace(Tag(0x0008, 0x1090), ElementsDictionaryEntry("Manufacturer's Model Name", "ManufacturerModelName",  "LO", "1"));
    public_dictionary.emplace(Tag(0x0008, 0x1100), ElementsDictionaryEntry("Referenced Results Sequence", "ReferencedResultsSequence",  "SQ", "1"));
    public_dictionary.emplace(Tag(0x0008, 0x1110), ElementsDictionaryEntry("Referenced Study Sequence", "ReferencedStudySequence",  "SQ", "1"));
    public_dictionary.emplace(Tag(0x0008, 0x1111), ElementsDictionaryEntry("Referenced Performed Procedure Step Sequence", "ReferencedPerformedProcedureStepSequence",  "SQ", "1"));
    public_dictionary.emplace(Tag(0x0008, 0x1115), ElementsDictionaryEntry("Referenced Series Sequence", "ReferencedSeriesSequence",  "SQ", "1"));
    public_dictionary.emplace(Tag(0x0008, 0x1120), ElementsDictionaryEntry("Referenced Patient Sequence", "ReferencedPatientSequence",  "SQ", "1"));
    public_dictionary.emplace(Tag(0x0008, 0x1125), ElementsDictionaryEntry("Referenced Visit Sequence", "ReferencedVisitSequence",  "SQ", "1"));
    public_dictionary.emplace(Tag(0x0008, 0x1130), ElementsDictionaryEntry("Referenced Overlay Sequence", "ReferencedOverlaySequence",  "SQ", "1"));
    public_dictionary.emplace(Tag(0x0008, 0x1134), ElementsDictionaryEntry("Referenced Stereometric Instance Sequence", "ReferencedStereometricInstanceSequence",  "SQ", "1"));
    public_dictionary.emplace(Tag(0x0008, 0x113a), ElementsDictionaryEntry("Referenced Waveform Sequence", "ReferencedWaveformSequence",  "SQ", "1"));
    public_dictionary.emplace(Tag(0x0008, 0x1140), ElementsDictionaryEntry("Referenced Image Sequence", "ReferencedImageSequence",  "SQ", "1"));
    public_dictionary.emplace(Tag(0x0008, 0x1145), ElementsDictionaryEntry("Referenced Curve Sequence", "ReferencedCurveSequence",  "SQ", "1"));
    public_dictionary.emplace(Tag(0x0008, 0x114a), ElementsDictionaryEntry("Referenced Instance Sequence", "ReferencedInstanceSequence",  "SQ", "1"));
    public_dictionary.emplace(Tag(0x0008, 0x114b), ElementsDictionaryEntry("Referenced Real World Value Mapping Instance Sequence", "ReferencedRealWorldValueMappingInstanceSequence",  "SQ", "1"));
    public_dictionary.emplace(Tag(0x0008, 0x1150), ElementsDictionaryEntry("Referenced SOP Class UID", "ReferencedSOPClassUID",  "UI", "1"));
    public_dictionary.emplace(Tag(0x0008, 0x1155), ElementsDictionaryEntry("Referenced SOP Instance UID", "ReferencedSOPInstanceUID",  "UI", "1"));
    public_dictionary.emplace(Tag(0x0008, 0x1156), ElementsDictionaryEntry("Definition Source Sequence", "DefinitionSourceSequence",  "SQ", "1"));
    public_dictionary.emplace(Tag(0x0008, 0x115a), ElementsDictionaryEntry("SOP Classes Supported", "SOPClassesSupported",  "UI", "1-n"));
    public_dictionary.emplace(Tag(0x0008, 0x1160), ElementsDictionaryEntry("Referenced Frame Number", "ReferencedFrameNumber",  "IS", "1-n"));
    public_dictionary.emplace(Tag(0x0008, 0x1161), ElementsDictionaryEntry("Simple Frame List", "SimpleFrameList",  "UL", "1-n"));
    public_dictionary.emplace(Tag(0x0008, 0x1162), ElementsDictionaryEntry("Calculated Frame List", "CalculatedFrameList",  "UL", "3-3n"));
    public_dictionary.emplace(Tag(0x0008, 0x1163), ElementsDictionaryEntry("Time Range", "TimeRange",  "FD", "2"));
    public_dictionary.emplace(Tag(0x0008, 0x1164), ElementsDictionaryEntry("Frame Extraction Sequence", "FrameExtractionSequence",  "SQ", "1"));
    public_dictionary.emplace(Tag(0x0008, 0x1167), ElementsDictionaryEntry("Multi-frame Source SOP Instance UID", "MultiFrameSourceSOPInstanceUID",  "UI", "1"));
    public_dictionary.emplace(Tag(0x0008, 0x1190), ElementsDictionaryEntry("Retrieve URL", "RetrieveURL",  "UR", "1"));
    public_dictionary.emplace(Tag(0x0008, 0x1195), ElementsDictionaryEntry("Transaction UID", "TransactionUID",  "UI", "1"));
    public_dictionary.emplace(Tag(0x0008, 0x1196), ElementsDictionaryEntry("Warning Reason", "WarningReason",  "US", "1"));
    public_dictionary.emplace(Tag(0x0008, 0x1197), ElementsDictionaryEntry("Failure Reason", "FailureReason",  "US", "1"));
    public_dictionary.emplace(Tag(0x0008, 0x1198), ElementsDictionaryEntry("Failed SOP Sequence", "FailedSOPSequence",  "SQ", "1"));
    public_dictionary.emplace(Tag(0x0008, 0x1199), ElementsDictionaryEntry("Referenced SOP Sequence", "ReferencedSOPSequence",  "SQ", "1"));
    public_dictionary.emplace(Tag(0x0008, 0x119a), ElementsDictionaryEntry("Other Failures Sequence", "OtherFailuresSequence",  "SQ", "1"));
    public_dictionary.emplace(Tag(0x0008, 0x1200), ElementsDictionaryEntry("Studies Containing Other Referenced Instances Sequence", "StudiesContainingOtherReferencedInstancesSequence",  "SQ", "1"));
    public_dictionary.emplace(Tag(0x0008, 0x1250), ElementsDictionaryEntry("Related Series Sequence", "RelatedSeriesSequence",  "SQ", "1"));
    public_dictionary.emplace(Tag(0x0008, 0x2110), ElementsDictionaryEntry("Lossy Image Compression (Retired)", "LossyImageCompressionRetired",  "CS", "1"));
    public_dictionary.emplace(Tag(0x0008, 0x2111), ElementsDictionaryEntry("Derivation Description", "DerivationDescription",  "ST", "1"));
    public_dictionary.emplace(Tag(0x0008, 0x2112), ElementsDictionaryEntry("Source Image Sequence", "SourceImageSequence",  "SQ", "1"));
    public_dictionary.emplace(Tag(0x0008, 0x2120), ElementsDictionaryEntry("Stage Name", "StageName",  "SH", "1"));
    public_dictionary.emplace(Tag(0x0008, 0x2122), ElementsDictionaryEntry("Stage Number", "StageNumber",  "IS", "1"));
    public_dictionary.emplace(Tag(0x0008, 0x2124), ElementsDictionaryEntry("Number of Stages", "NumberOfStages",  "IS", "1"));
    public_dictionary.emplace(Tag(0x0008, 0x2127), ElementsDictionaryEntry("View Name", "ViewName",  "SH", "1"));
    public_dictionary.emplace(Tag(0x0008, 0x2128), ElementsDictionaryEntry("View Number", "ViewNumber",  "IS", "1"));
    public_dictionary.emplace(Tag(0x0008, 0x2129), ElementsDictionaryEntry("Number of Event Timers", "NumberOfEventTimers",  "IS", "1"));
    public_dictionary.emplace(Tag(0x0008, 0x212a), ElementsDictionaryEntry("Number of Views in Stage", "NumberOfViewsInStage",  "IS", "1"));
    public_dictionary.emplace(Tag(0x0008, 0x2130), ElementsDictionaryEntry("Event Elapsed Time(s)", "EventElapsedTimes",  "DS", "1-n"));
    public_dictionary.emplace(Tag(0x0008, 0x2132), ElementsDictionaryEntry("Event Timer Name(s)", "EventTimerNames",  "LO", "1-n"));
    public_dictionary.emplace(Tag(0x0008, 0x2133), ElementsDictionaryEntry("Event Timer Sequence", "EventTimerSequence",  "SQ", "1"));
    public_dictionary.emplace(Tag(0x0008, 0x2134), ElementsDictionaryEntry("Event Time Offset", "EventTimeOffset",  "FD", "1"));
    public_dictionary.emplace(Tag(0x0008, 0x2135), ElementsDictionaryEntry("Event Code Sequence", "EventCodeSequence",  "SQ", "1"));
    public_dictionary.emplace(Tag(0x0008, 0x2142), ElementsDictionaryEntry("Start Trim", "StartTrim",  "IS", "1"));
    public_dictionary.emplace(Tag(0x0008, 0x2143), ElementsDictionaryEntry("Stop Trim", "StopTrim",  "IS", "1"));
    public_dictionary.emplace(Tag(0x0008, 0x2144), ElementsDictionaryEntry("Recommended Display Frame Rate", "RecommendedDisplayFrameRate",  "IS", "1"));
    public_dictionary.emplace(Tag(0x0008, 0x2200), ElementsDictionaryEntry("Transducer Position", "TransducerPosition",  "CS", "1"));
    public_dictionary.emplace(Tag(0x0008, 0x2204), ElementsDictionaryEntry("Transducer Orientation", "TransducerOrientation",  "CS", "1"));
    public_dictionary.emplace(Tag(0x0008, 0x2208), ElementsDictionaryEntry("Anatomic Structure", "AnatomicStructure",  "CS", "1"));
    public_dictionary.emplace(Tag(0x0008, 0x2218), ElementsDictionaryEntry("Anatomic Region Sequence", "AnatomicRegionSequence",  "SQ", "1"));
    public_dictionary.emplace(Tag(0x0008, 0x2220), ElementsDictionaryEntry("Anatomic Region Modifier Sequence", "AnatomicRegionModifierSequence",  "SQ", "1"));
    public_dictionary.emplace(Tag(0x0008, 0x2228), ElementsDictionaryEntry("Primary Anatomic Structure Sequence", "PrimaryAnatomicStructureSequence",  "SQ", "1"));
    public_dictionary.emplace(Tag(0x0008, 0x2229), ElementsDictionaryEntry("Anatomic Structure, Space or Region Sequence", "AnatomicStructureSpaceOrRegionSequence",  "SQ", "1"));
    public_dictionary.emplace(Tag(0x0008, 0x2230), ElementsDictionaryEntry("Primary Anatomic Structure Modifier Sequence", "PrimaryAnatomicStructureModifierSequence",  "SQ", "1"));
    public_dictionary.emplace(Tag(0x0008, 0x2240), ElementsDictionaryEntry("Transducer Position Sequence", "TransducerPositionSequence",  "SQ", "1"));
    public_dictionary.emplace(Tag(0x0008, 0x2242), ElementsDictionaryEntry("Transducer Position Modifier Sequence", "TransducerPositionModifierSequence",  "SQ", "1"));
    public_dictionary.emplace(Tag(0x0008, 0x2244), ElementsDictionaryEntry("Transducer Orientation Sequence", "TransducerOrientationSequence",  "SQ", "1"));
    public_dictionary.emplace(Tag(0x0008, 0x2246), ElementsDictionaryEntry("Transducer Orientation Modifier Sequence", "TransducerOrientationModifierSequence",  "SQ", "1"));
    public_dictionary.emplace(Tag(0x0008, 0x2251), ElementsDictionaryEntry("Anatomic Structure Space Or Region Code Sequence (Trial)", "AnatomicStructureSpaceOrRegionCodeSequenceTrial",  "SQ", "1"));
    public_dictionary.emplace(Tag(0x0008, 0x2253), ElementsDictionaryEntry("Anatomic Portal Of Entrance Code Sequence (Trial)", "AnatomicPortalOfEntranceCodeSequenceTrial",  "SQ", "1"));
    public_dictionary.emplace(Tag(0x0008, 0x2255), ElementsDictionaryEntry("Anatomic Approach Direction Code Sequence (Trial)", "AnatomicApproachDirectionCodeSequenceTrial",  "SQ", "1"));
    public_dictionary.emplace(Tag(0x0008, 0x2256), ElementsDictionaryEntry("Anatomic Perspective Description (Trial)", "AnatomicPerspectiveDescriptionTrial",  "ST", "1"));
    public_dictionary.emplace(Tag(0x0008, 0x2257), ElementsDictionaryEntry("Anatomic Perspective Code Sequence (Trial)", "AnatomicPerspectiveCodeSequenceTrial",  "SQ", "1"));
    public_dictionary.emplace(Tag(0x0008, 0x2258), ElementsDictionaryEntry("Anatomic Location Of Examining Instrument Description (Trial)", "AnatomicLocationOfExaminingInstrumentDescriptionTrial",  "ST", "1"));
    public_dictionary.emplace(Tag(0x0008, 0x2259), ElementsDictionaryEntry("Anatomic Location Of Examining Instrument Code Sequence (Trial)", "AnatomicLocationOfExaminingInstrumentCodeSequenceTrial",  "SQ", "1"));
    public_dictionary.emplace(Tag(0x0008, 0x225a), ElementsDictionaryEntry("Anatomic Structure Space Or Region Modifier Code Sequence (Trial)", "AnatomicStructureSpaceOrRegionModifierCodeSequenceTrial",  "SQ", "1"));
    public_dictionary.emplace(Tag(0x0008, 0x225c), ElementsDictionaryEntry("On Axis Background Anatomic Structure Code Sequence (Trial)", "OnAxisBackgroundAnatomicStructureCodeSequenceTrial",  "SQ", "1"));
    public_dictionary.emplace(Tag(0x0008, 0x3001), ElementsDictionaryEntry("Alternate Representation Sequence", "AlternateRepresentationSequence",  "SQ", "1"));
    public_dictionary.emplace(Tag(0x0008, 0x3002), ElementsDictionaryEntry("Available Transfer Syntax UID", "AvailableTransferSyntaxUID",  "UI", "1-n"));
    public_dictionary.emplace(Tag(0x0008, 0x3010), ElementsDictionaryEntry("Irradiation Event UID", "IrradiationEventUID",  "UI", "1-n"));
    public_dictionary.emplace(Tag(0x0008, 0x3011), ElementsDictionaryEntry("Source Irradiation Event Sequence", "SourceIrradiationEventSequence",  "SQ", "1"));
    public_dictionary.emplace(Tag(0x0008, 0x3012), ElementsDictionaryEntry("Radiopharmaceutical Administration Event UID", "RadiopharmaceuticalAdministrationEventUID",  "UI", "1"));
    public_dictionary.emplace(Tag(0x0008, 0x4000), ElementsDictionaryEntry("Identifying Comments", "IdentifyingComments",  "LT", "1"));
    public_dictionary.emplace(Tag(0x0008, 0x9007), ElementsDictionaryEntry("Frame Type", "FrameType",  "CS", "4"));
    public_dictionary.emplace(Tag(0x0008, 0x9092), ElementsDictionaryEntry("Referenced Image Evidence Sequence", "ReferencedImageEvidenceSequence",  "SQ", "1"));
    public_dictionary.emplace(Tag(0x0008, 0x9121), ElementsDictionaryEntry("Referenced Raw Data Sequence", "ReferencedRawDataSequence",  "SQ", "1"));
    public_dictionary.emplace(Tag(0x0008, 0x9123), ElementsDictionaryEntry("Creator-Version UID", "CreatorVersionUID",  "UI", "1"));
    public_dictionary.emplace(Tag(0x0008, 0x9124), ElementsDictionaryEntry("Derivation Image Sequence", "DerivationImageSequence",  "SQ", "1"));
    public_dictionary.emplace(Tag(0x0008, 0x9154), ElementsDictionaryEntry("Source Image Evidence Sequence", "SourceImageEvidenceSequence",  "SQ", "1"));
    public_dictionary.emplace(Tag(0x0008, 0x9205), ElementsDictionaryEntry("Pixel Presentation", "PixelPresentation",  "CS", "1"));
    public_dictionary.emplace(Tag(0x0008, 0x9206), ElementsDictionaryEntry("Volumetric Properties", "VolumetricProperties",  "CS", "1"));
    public_dictionary.emplace(Tag(0x0008, 0x9207), ElementsDictionaryEntry("Volume Based Calculation Technique", "VolumeBasedCalculationTechnique",  "CS", "1"));
    public_dictionary.emplace(Tag(0x0008, 0x9208), ElementsDictionaryEntry("Complex Image Component", "ComplexImageComponent",  "CS", "1"));
    public_dictionary.emplace(Tag(0x0008, 0x9209), ElementsDictionaryEntry("Acquisition Contrast", "AcquisitionContrast",  "CS", "1"));
    public_dictionary.emplace(Tag(0x0008, 0x9215), ElementsDictionaryEntry("Derivation Code Sequence", "DerivationCodeSequence",  "SQ", "1"));
    public_dictionary.emplace(Tag(0x0008, 0x9237), ElementsDictionaryEntry("Referenced Presentation State Sequence", "ReferencedPresentationStateSequence",  "SQ", "1"));
    public_dictionary.emplace(Tag(0x0008, 0x9410), ElementsDictionaryEntry("Referenced Other Plane Sequence", "ReferencedOtherPlaneSequence",  "SQ", "1"));
    public_dictionary.emplace(Tag(0x0008, 0x9458), ElementsDictionaryEntry("Frame Display Sequence", "FrameDisplaySequence",  "SQ", "1"));
    public_dictionary.emplace(Tag(0x0008, 0x9459), ElementsDictionaryEntry("Recommended Display Frame Rate in Float", "RecommendedDisplayFrameRateInFloat",  "FL", "1"));
    public_dictionary.emplace(Tag(0x0008, 0x9460), ElementsDictionaryEntry("Skip Frame Range Flag", "SkipFrameRangeFlag",  "CS", "1"));

    public_tags.emplace("LengthToEnd", Tag(0x0008, 0x0001));
    public_tags.emplace("SpecificCharacterSet", Tag(0x0008, 0x0005));
    public_tags.emplace("LanguageCodeSequence", Tag(0x0008, 0x0006));
    public_tags.emplace("ImageType", Tag(0x0008, 0x0008));
    public_tags.emplace("RecognitionCode", Tag(0x0008, 0x0010));
    public_tags.emplace("InstanceCreationDate", Tag(0x0008, 0x0012));
    public_tags.emplace("InstanceCreationTime", Tag(0x0008, 0x0013));
    public_tags.emplace("InstanceCreatorUID", Tag(0x0008, 0x0014));
    public_tags.emplace("InstanceCoercionDateTime", Tag(0x0008, 0x0015));
    public_tags.emplace("SOPClassUID", Tag(0x0008, 0x0016));
    public_tags.emplace("AcquisitionUID", Tag(0x0008, 0x0017));
    public_tags.emplace("SOPInstanceUID", Tag(0x0008, 0x0018));
    public_tags.emplace("PyramidUID", Tag(0x0008, 0x0019));
    public_tags.emplace("RelatedGeneralSOPClassUID", Tag(0x0008, 0x001a));
    public_tags.emplace("OriginalSpecializedSOPClassUID", Tag(0x0008, 0x001b));
    public_tags.emplace("StudyDate", Tag(0x0008, 0x0020));
    public_tags.emplace("SeriesDate", Tag(0x0008, 0x0021));
    public_tags.emplace("AcquisitionDate", Tag(0x0008, 0x0022));
    public_tags.emplace("ContentDate", Tag(0x0008, 0x0023));
    public_tags.emplace("OverlayDate", Tag(0x0008, 0x0024));
    public_tags.emplace("CurveDate", Tag(0x0008, 0x0025));
    public_tags.emplace("AcquisitionDateTime", Tag(0x0008, 0x002a));
    public_tags.emplace("StudyTime", Tag(0x0008, 0x0030));
    public_tags.emplace("SeriesTime", Tag(0x0008, 0x0031));
    public_tags.emplace("AcquisitionTime", Tag(0x0008, 0x0032));
    public_tags.emplace("ContentTime", Tag(0x0008, 0x0033));
    public_tags.emplace("OverlayTime", Tag(0x0008, 0x0034));
    public_tags.emplace("CurveTime", Tag(0x0008, 0x0035));
    public_tags.emplace("DataSetType", Tag(0x0008, 0x0040));
    public_tags.emplace("DataSetSubtype", Tag(0x0008, 0x0041));
    public_tags.emplace("NuclearMedicineSeriesType", Tag(0x0008, 0x0042));
    public_tags.emplace("AccessionNumber", Tag(0x0008, 0x0050));
    public_tags.emplace("IssuerOfAccessionNumberSequence", Tag(0x0008, 0x0051));
    public_tags.emplace("QueryRetrieveLevel", Tag(0x0008, 0x0052));
    public_tags.emplace("QueryRetrieveView", Tag(0x0008, 0x0053));
    public_tags.emplace("RetrieveAETitle", Tag(0x0008, 0x0054));
    public_tags.emplace("StationAETitle", Tag(0x0008, 0x0055));
    public_tags.emplace("InstanceAvailability", Tag(0x0008, 0x0056));
    public_tags.emplace("FailedSOPInstanceUIDList", Tag(0x0008, 0x0058));
    public_tags.emplace("Modality", Tag(0x0008, 0x0060));
    public_tags.emplace("ModalitiesInStudy", Tag(0x0008, 0x0061));
    public_tags.emplace("SOPClassesInStudy", Tag(0x0008, 0x0062));
    public_tags.emplace("AnatomicRegionsInStudyCodeSequence", Tag(0x0008, 0x0063));
    public_tags.emplace("ConversionType", Tag(0x0008, 0x0064));
    public_tags.emplace("PresentationIntentType", Tag(0x0008, 0x0068));
    public_tags.emplace("Manufacturer", Tag(0x0008, 0x0070));
    public_tags.emplace("InstitutionName", Tag(0x0008, 0x0080));
    public_tags.emplace("InstitutionAddress", Tag(0x0008, 0x0081));
    public_tags.emplace("InstitutionCodeSequence", Tag(0x0008, 0x0082));
    public_tags.emplace("ReferringPhysicianName", Tag(0x0008, 0x0090));
    public_tags.emplace("ReferringPhysicianAddress", Tag(0x0008, 0x0092));
    public_tags.emplace("ReferringPhysicianTelephoneNumbers", Tag(0x0008, 0x0094));
    public_tags.emplace("ReferringPhysicianIdentificationSequence", Tag(0x0008, 0x0096));
    public_tags.emplace("ConsultingPhysicianName", Tag(0x0008, 0x009c));
    public_tags.emplace("ConsultingPhysicianIdentificationSequence", Tag(0x0008, 0x009d));
    public_tags.emplace("CodeValue", Tag(0x0008, 0x0100));
    public_tags.emplace("ExtendedCodeValue", Tag(0x0008, 0x0101));
    public_tags.emplace("CodingSchemeDesignator", Tag(0x0008, 0x0102));
    public_tags.emplace("CodingSchemeVersion", Tag(0x0008, 0x0103));
    public_tags.emplace("CodeMeaning", Tag(0x0008, 0x0104));
    public_tags.emplace("MappingResource", Tag(0x0008, 0x0105));
    public_tags.emplace("ContextGroupVersion", Tag(0x0008, 0x0106));
    public_tags.emplace("ContextGroupLocalVersion", Tag(0x0008, 0x0107));
    public_tags.emplace("ExtendedCodeMeaning", Tag(0x0008, 0x0108));
    public_tags.emplace("CodingSchemeResourcesSequence", Tag(0x0008, 0x0109));
    public_tags.emplace("CodingSchemeURLType", Tag(0x0008, 0x010a));
    public_tags.emplace("ContextGroupExtensionFlag", Tag(0x0008, 0x010b));
    public_tags.emplace("CodingSchemeUID", Tag(0x0008, 0x010c));
    public_tags.emplace("ContextGroupExtensionCreatorUID", Tag(0x0008, 0x010d));
    public_tags.emplace("CodingSchemeURL", Tag(0x0008, 0x010e));
    public_tags.emplace("ContextIdentifier", Tag(0x0008, 0x010f));
    public_tags.emplace("CodingSchemeIdentificationSequence", Tag(0x0008, 0x0110));
    public_tags.emplace("CodingSchemeRegistry", Tag(0x0008, 0x0112));
    public_tags.emplace("CodingSchemeExternalID", Tag(0x0008, 0x0114));
    public_tags.emplace("CodingSchemeName", Tag(0x0008, 0x0115));
    public_tags.emplace("CodingSchemeResponsibleOrganization", Tag(0x0008, 0x0116));
    public_tags.emplace("ContextUID", Tag(0x0008, 0x0117));
    public_tags.emplace("MappingResourceUID", Tag(0x0008, 0x0118));
    public_tags.emplace("LongCodeValue", Tag(0x0008, 0x0119));
    public_tags.emplace("URNCodeValue", Tag(0x0008, 0x0120));
    public_tags.emplace("EquivalentCodeSequence", Tag(0x0008, 0x0121));
    public_tags.emplace("MappingResourceName", Tag(0x0008, 0x0122));
    public_tags.emplace("ContextGroupIdentificationSequence", Tag(0x0008, 0x0123));
    public_tags.emplace("MappingResourceIdentificationSequence", Tag(0x0008, 0x0124));
    public_tags.emplace("TimezoneOffsetFromUTC", Tag(0x0008, 0x0201));
    public_tags.emplace("ResponsibleGroupCodeSequence", Tag(0x0008, 0x0220));
    public_tags.emplace("EquipmentModality", Tag(0x0008, 0x0221));
    public_tags.emplace("ManufacturerRelatedModelGroup", Tag(0x0008, 0x0222));
    public_tags.emplace("PrivateDataElementCharacteristicsSequence", Tag(0x0008, 0x0300));
    public_tags.emplace("PrivateGroupReference", Tag(0x0008, 0x0301));
    public_tags.emplace("PrivateCreatorReference", Tag(0x0008, 0x0302));
    public_tags.emplace("BlockIdentifyingInformationStatus", Tag(0x0008, 0x0303));
    public_tags.emplace("NonidentifyingPrivateElements", Tag(0x0008, 0x0304));
    public_tags.emplace("IdentifyingPrivateElements", Tag(0x0008, 0x0306));
    public_tags.emplace("DeidentificationActionSequence", Tag(0x0008, 0x0305));
    public_tags.emplace("DeidentificationAction", Tag(0x0008, 0x0307));
    public_tags.emplace("PrivateDataElement", Tag(0x0008, 0x0308));
    public_tags.emplace("PrivateDataElementValueMultiplicity", Tag(0x0008, 0x0309));
    public_tags.emplace("PrivateDataElementValueRepresentation", Tag(0x0008, 0x030a));
    public_tags.emplace("PrivateDataElementNumberOfItems", Tag(0x0008, 0x030b));
    public_tags.emplace("PrivateDataElementName", Tag(0x0008, 0x030c));
    public_tags.emplace("PrivateDataElementKeyword", Tag(0x0008, 0x030d));
    public_tags.emplace("PrivateDataElementDescription", Tag(0x0008, 0x030e));
    public_tags.emplace("PrivateDataElementEncoding", Tag(0x0008, 0x030f));
    public_tags.emplace("PrivateDataElementDefinitionSequence", Tag(0x0008, 0x0310));
    public_tags.emplace("NetworkID", Tag(0x0008, 0x1000));
    public_tags.emplace("StationName", Tag(0x0008, 0x1010));
    public_tags.emplace("StudyDescription", Tag(0x0008, 0x1030));
    public_tags.emplace("ProcedureCodeSequence", Tag(0x0008, 0x1032));
    public_tags.emplace("SeriesDescription", Tag(0x0008, 0x103e));
    public_tags.emplace("SeriesDescriptionCodeSequence", Tag(0x0008, 0x103f));
    public_tags.emplace("InstitutionalDepartmentName", Tag(0x0008, 0x1040));
    public_tags.emplace("InstitutionalDepartmentTypeCodeSequence", Tag(0x0008, 0x1041));
    public_tags.emplace("PhysiciansOfRecord", Tag(0x0008, 0x1048));
    public_tags.emplace("PhysiciansOfRecordIdentificationSequence", Tag(0x0008, 0x1049));
    public_tags.emplace("PerformingPhysicianName", Tag(0x0008, 0x1050));
    public_tags.emplace("PerformingPhysicianIdentificationSequence", Tag(0x0008, 0x1052));
    public_tags.emplace("NameOfPhysiciansReadingStudy", Tag(0x0008, 0x1060));
    public_tags.emplace("PhysiciansReadingStudyIdentificationSequence", Tag(0x0008, 0x1062));
    public_tags.emplace("OperatorsName", Tag(0x0008, 0x1070));
    public_tags.emplace("OperatorIdentificationSequence", Tag(0x0008, 0x1072));
    public_tags.emplace("AdmittingDiagnosesDescription", Tag(0x0008, 0x1080));
    public_tags.emplace("AdmittingDiagnosesCodeSequence", Tag(0x0008, 0x1084));
    public_tags.emplace("PyramidDescription", Tag(0x0008, 0x1088));
    public_tags.emplace("ManufacturerModelName", Tag(0x0008, 0x1090));
    public_tags.emplace("ReferencedResultsSequence", Tag(0x0008, 0x1100));
    public_tags.emplace("ReferencedStudySequence", Tag(0x0008, 0x1110));
    public_tags.emplace("ReferencedPerformedProcedureStepSequence", Tag(0x0008, 0x1111));
    public_tags.emplace("ReferencedSeriesSequence", Tag(0x0008, 0x1115));
    public_tags.emplace("ReferencedPatientSequence", Tag(0x0008, 0x1120));
    public_tags.emplace("ReferencedVisitSequence", Tag(0x0008, 0x1125));
    public_tags.emplace("ReferencedOverlaySequence", Tag(0x0008, 0x1130));
    public_tags.emplace("ReferencedStereometricInstanceSequence", Tag(0x0008, 0x1134));
    public_tags.emplace("ReferencedWaveformSequence", Tag(0x0008, 0x113a));
    public_tags.emplace("ReferencedImageSequence", Tag(0x0008, 0x1140));
    public_tags.emplace("ReferencedCurveSequence", Tag(0x0008, 0x1145));
    public_tags.emplace("ReferencedInstanceSequence", Tag(0x0008, 0x114a));
    public_tags.emplace("ReferencedRealWorldValueMappingInstanceSequence", Tag(0x0008, 0x114b));
    public_tags.emplace("ReferencedSOPClassUID", Tag(0x0008, 0x1150));
    public_tags.emplace("ReferencedSOPInstanceUID", Tag(0x0008, 0x1155));
    public_tags.emplace("DefinitionSourceSequence", Tag(0x0008, 0x1156));
    public_tags.emplace("SOPClassesSupported", Tag(0x0008, 0x115a));
    public_tags.emplace("ReferencedFrameNumber", Tag(0x0008, 0x1160));
    public_tags.emplace("SimpleFrameList", Tag(0x0008, 0x1161));
    public_tags.emplace("CalculatedFrameList", Tag(0x0008, 0x1162));
    public_tags.emplace("TimeRange", Tag(0x0008, 0x1163));
    public_tags.emplace("FrameExtractionSequence", Tag(0x0008, 0x1164));
    public_tags.emplace("MultiFrameSourceSOPInstanceUID", Tag(0x0008, 0x1167));
    public_tags.emplace("RetrieveURL", Tag(0x0008, 0x1190));
    public_tags.emplace("TransactionUID", Tag(0x0008, 0x1195));
    public_tags.emplace("WarningReason", Tag(0x0008, 0x1196));
    public_tags.emplace("FailureReason", Tag(0x0008, 0x1197));
    public_tags.emplace("FailedSOPSequence", Tag(0x0008, 0x1198));
    public_tags.emplace("ReferencedSOPSequence", Tag(0x0008, 0x1199));
    public_tags.emplace("OtherFailuresSequence", Tag(0x0008, 0x119a));
    public_tags.emplace("StudiesContainingOtherReferencedInstancesSequence", Tag(0x0008, 0x1200));
    public_tags.emplace("RelatedSeriesSequence", Tag(0x0008, 0x1250));
    public_tags.emplace("LossyImageCompressionRetired", Tag(0x0008, 0x2110));
    public_tags.emplace("DerivationDescription", Tag(0x0008, 0x2111));
    public_tags.emplace("SourceImageSequence", Tag(0x0008, 0x2112));
    public_tags.emplace("StageName", Tag(0x0008, 0x2120));
    public_tags.emplace("StageNumber", Tag(0x0008, 0x2122));
    public_tags.emplace("NumberOfStages", Tag(0x0008, 0x2124));
    public_tags.emplace("ViewName", Tag(0x0008, 0x2127));
    public_tags.emplace("ViewNumber", Tag(0x0008, 0x2128));
    public_tags.emplace("NumberOfEventTimers", Tag(0x0008, 0x2129));
    public_tags.emplace("NumberOfViewsInStage", Tag(0x0008, 0x212a));
    public_tags.emplace("EventElapsedTimes", Tag(0x0008, 0x2130));
    public_tags.emplace("EventTimerNames", Tag(0x0008, 0x2132));
    public_tags.emplace("EventTimerSequence", Tag(0x0008, 0x2133));
    public_tags.emplace("EventTimeOffset", Tag(0x0008, 0x2134));
    public_tags.emplace("EventCodeSequence", Tag(0x0008, 0x2135));
    public_tags.emplace("StartTrim", Tag(0x0008, 0x2142));
    public_tags.emplace("StopTrim", Tag(0x0008, 0x2143));
    public_tags.emplace("RecommendedDisplayFrameRate", Tag(0x0008, 0x2144));
    public_tags.emplace("TransducerPosition", Tag(0x0008, 0x2200));
    public_tags.emplace("TransducerOrientation", Tag(0x0008, 0x2204));
    public_tags.emplace("AnatomicStructure", Tag(0x0008, 0x2208));
    public_tags.emplace("AnatomicRegionSequence", Tag(0x0008, 0x2218));
    public_tags.emplace("AnatomicRegionModifierSequence", Tag(0x0008, 0x2220));
    public_tags.emplace("PrimaryAnatomicStructureSequence", Tag(0x0008, 0x2228));
    public_tags.emplace("AnatomicStructureSpaceOrRegionSequence", Tag(0x0008, 0x2229));
    public_tags.emplace("PrimaryAnatomicStructureModifierSequence", Tag(0x0008, 0x2230));
    public_tags.emplace("TransducerPositionSequence", Tag(0x0008, 0x2240));
    public_tags.emplace("TransducerPositionModifierSequence", Tag(0x0008, 0x2242));
    public_tags.emplace("TransducerOrientationSequence", Tag(0x0008, 0x2244));
    public_tags.emplace("TransducerOrientationModifierSequence", Tag(0x0008, 0x2246));
    public_tags.emplace("AnatomicStructureSpaceOrRegionCodeSequenceTrial", Tag(0x0008, 0x2251));
    public_tags.emplace("AnatomicPortalOfEntranceCodeSequenceTrial", Tag(0x0008, 0x2253));
    public_tags.emplace("AnatomicApproachDirectionCodeSequenceTrial", Tag(0x0008, 0x2255));
    public_tags.emplace("AnatomicPerspectiveDescriptionTrial", Tag(0x0008, 0x2256));
    public_tags.emplace("AnatomicPerspectiveCodeSequenceTrial", Tag(0x0008, 0x2257));
    public_tags.emplace("AnatomicLocationOfExaminingInstrumentDescriptionTrial", Tag(0x0008, 0x2258));
    public_tags.emplace("AnatomicLocationOfExaminingInstrumentCodeSequenceTrial", Tag(0x0008, 0x2259));
    public_tags.emplace("AnatomicStructureSpaceOrRegionModifierCodeSequenceTrial", Tag(0x0008, 0x225a));
    public_tags.emplace("OnAxisBackgroundAnatomicStructureCodeSequenceTrial", Tag(0x0008, 0x225c));
    public_tags.emplace("AlternateRepresentationSequence", Tag(0x0008, 0x3001));
    public_tags.emplace("AvailableTransferSyntaxUID", Tag(0x0008, 0x3002));
    public_tags.emplace("IrradiationEventUID", Tag(0x0008, 0x3010));
    public_tags.emplace("SourceIrradiationEventSequence", Tag(0x0008, 0x3011));
    public_tags.emplace("RadiopharmaceuticalAdministrationEventUID", Tag(0x0008, 0x3012));
    public_tags.emplace("IdentifyingComments", Tag(0x0008, 0x4000));
    public_tags.emplace("FrameType", Tag(0x0008, 0x9007));
    public_tags.emplace("ReferencedImageEvidenceSequence", Tag(0x0008, 0x9092));
    public_tags.emplace("ReferencedRawDataSequence", Tag(0x0008, 0x9121));
    public_tags.emplace("CreatorVersionUID", Tag(0x0008, 0x9123));
    public_tags.emplace("DerivationImageSequence", Tag(0x0008, 0x9124));
    public_tags.emplace("SourceImageEvidenceSequence", Tag(0x0008, 0x9154));
    public_tags.emplace("PixelPresentation", Tag(0x0008, 0x9205));
    public_tags.emplace("VolumetricProperties", Tag(0x0008, 0x9206));
    public_tags.emplace("VolumeBasedCalculationTechnique", Tag(0x0008, 0x9207));
    public_tags.emplace("ComplexImageComponent", Tag(0x0008, 0x9208));
    public_tags.emplace("AcquisitionContrast", Tag(0x0008, 0x9209));
    public_tags.emplace("DerivationCodeSequence", Tag(0x0008, 0x9215));
    public_tags.emplace("ReferencedPresentationStateSequence", Tag(0x0008, 0x9237));
    public_tags.emplace("ReferencedOtherPlaneSequence", Tag(0x0008, 0x9410));
    public_tags.emplace("FrameDisplaySequence", Tag(0x0008, 0x9458));
    public_tags.emplace("RecommendedDisplayFrameRateInFloat", Tag(0x0008, 0x9459));
    public_tags.emplace("SkipFrameRangeFlag", Tag(0x0008, 0x9460));
}

}

}